/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ImportExportToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmEventProperties;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingOption;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.ImportFileTemplateWizardPage;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.ImportServerTemplateWizardPage;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.JRTExportWizardPage;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PathElement;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.Property;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportExportTemplateWizardToolkit {
    private static final int MAX_DIALOG_HEIGHT = 700;
    private static final int MIN_DIALOG_HEIGHT = 500;
    private static final int MAX_DIALOG_WIDTH = 700;
    private static final int MIN_DIALOG_WIDTH = 500;

    private ImportExportTemplateWizardToolkit() {
    }

    public static RecordingTemplate openImportServerTemplateWizard(Shell parentShell, IFlightRecorderService service) {
        ImportServerTemplateWizardPage importServerTemplateWizardPage = new ImportServerTemplateWizardPage(service);
        OnePageWizardDialog dialog = new OnePageWizardDialog(parentShell, (IWizardPage)importServerTemplateWizardPage);
        dialog.setWidthConstaint(500, 700);
        dialog.setHeightConstraint(500, 700);
        if (dialog.open() == 0) {
            return importServerTemplateWizardPage.getRecordingTemplate();
        }
        return null;
    }

    public static RecordingTemplate openImportFileTemplateWizard(Shell parentShell, IFlightRecorderService service) {
        ImportFileTemplateWizardPage importFileTemplateWizardPage = new ImportFileTemplateWizardPage(service);
        OnePageWizardDialog dialog = new OnePageWizardDialog(parentShell, (IWizardPage)importFileTemplateWizardPage);
        dialog.setWidthConstaint(500, 700);
        dialog.setHeightConstraint(500, 700);
        if (dialog.open() == 0) {
            return importFileTemplateWizardPage.getRecordingTemplate();
        }
        return null;
    }

    public static boolean openExportFileTemplateWizard(Shell parentShell, RecordingTemplate template, JvmEventProperties serverProperties) {
        JRTExportWizardPage wizardPage = new JRTExportWizardPage(template, serverProperties);
        OnePageWizardDialog dialog = new OnePageWizardDialog(parentShell, (IWizardPage)wizardPage);
        dialog.setWidthConstaint(500, 700);
        dialog.setHeightConstraint(500, 700);
        dialog.setDialogSettings(ControlPanel.getDefault().getDialogSettings());
        if (dialog.open() == 0) {
            RecordingTemplate exportTemplate = ImportExportTemplateWizardToolkit.createTemplateWithExportedSettings(template, wizardPage.getExportedItems());
            try {
                ImportExportToolkit.exportFile(exportTemplate, wizardPage.getExportFile());
            }
            catch (IOException e) {
                DialogToolkit.showException((Shell)parentShell, (String)Messages.IMPORT_EXPORT_TOOLKIT_COULD_NOT_EXPORT_DIALOG_TITLE, (String)NLS.bind((String)Messages.IMPORT_EXPORT_TOOLKIT_COULD_NOT_EXPORT_DIALOG_MESSAGE, (Object)e.getLocalizedMessage()), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static RecordingTemplate createTemplateWithExportedSettings(RecordingTemplate template, Collection<PathElement> elementsToExport) {
        RecordingTemplate exportTemplate = new RecordingTemplate();
        exportTemplate.setName(template.getName());
        exportTemplate.setDescription(template.getDescription());
        for (PathElement element : elementsToExport) {
            RecordingOption option;
            if (!(element instanceof Property) || (option = template.findOption(element.getPath())) == null) continue;
            exportTemplate.setOption(option);
        }
        return exportTemplate;
    }
}

