/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmEventProperties;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingOption;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.ImportExportTemplateWizardToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingTemplatePart;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class ImportExportTemplateButtonToolkit {
    private Shell m_parentShell;
    private IFlightRecorderService m_flightRecorderService;
    private RecordingTemplate m_recordingTemplate;
    private RecordingTemplatePart m_recordingTemplateViewer;

    public ImportExportTemplateButtonToolkit(Shell parentShell, IFlightRecorderService flightRecorderService, RecordingTemplate recordingTemplate, RecordingTemplatePart recordingTemplateViewer) {
        this.m_parentShell = parentShell;
        this.m_flightRecorderService = flightRecorderService;
        this.m_recordingTemplate = recordingTemplate;
        this.m_recordingTemplateViewer = recordingTemplateViewer;
    }

    public Control createButtonContainer(Composite parent, boolean includeExportButton) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        Button importFileButton = this.createImportFileTemplateButton(container);
        importFileButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Button importServerButton = this.createImportServerTemplateButton(container);
        importServerButton.setLayoutData((Object)gd2);
        if (includeExportButton) {
            GridData gd3 = new GridData(4, 4, true, false);
            Button exportButton = this.createExportFileTemplateButton(container);
            exportButton.setLayoutData((Object)gd3);
        }
        GridData gd4 = new GridData(4, 4, true, false);
        Label padLabel = new Label(container, 0);
        padLabel.setLayoutData((Object)gd4);
        GridData gd5 = new GridData(4, 4, true, false);
        Button clearButton = this.createClearTemplateButton(container);
        clearButton.setLayoutData((Object)gd5);
        return container;
    }

    public Button createImportServerTemplateButton(Composite container) {
        Button button = new Button(container, 0);
        button.setText(Messages.BUTTON_IMPORT_SERVER_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportTemplateButtonToolkit.this.openImportServerTemplateWizard();
            }
        });
        return button;
    }

    public Button createExportFileTemplateButton(Composite container) {
        Button button = new Button(container, 0);
        button.setText(Messages.BUTTON_EXPORT_FILE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportTemplateButtonToolkit.this.openExportFileTemplateWizard();
            }
        });
        return button;
    }

    public Button createImportFileTemplateButton(Composite container) {
        Button button = new Button(container, 0);
        button.setText(Messages.BUTTON_IMPORT_FILE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportTemplateButtonToolkit.this.openImportFileTemplateWizard();
            }
        });
        return button;
    }

    public Button createClearTemplateButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_CLEAR_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportTemplateButtonToolkit.this.clearRecordingTemplate();
            }
        });
        return button;
    }

    protected void clearRecordingTemplate() {
        this.m_recordingTemplate.setName(Messages.RECORDING_TEMPLATE_NEW_NAME);
        this.m_recordingTemplate.setDescription("");
        this.m_recordingTemplate.getOptions().clear();
        this.m_recordingTemplateViewer.setInput(this.m_recordingTemplate);
    }

    private void openExportFileTemplateWizard() {
        ImportExportTemplateWizardToolkit.openExportFileTemplateWizard(this.m_parentShell, this.m_recordingTemplate, new JvmEventProperties(this.m_flightRecorderService));
    }

    private void openImportFileTemplateWizard() {
        RecordingTemplate fileTemplate = ImportExportTemplateWizardToolkit.openImportFileTemplateWizard(this.m_parentShell, this.m_flightRecorderService);
        if (fileTemplate != null) {
            this.updateRecordingTemplate(fileTemplate);
        }
    }

    private void openImportServerTemplateWizard() {
        RecordingTemplate serverTemplate = ImportExportTemplateWizardToolkit.openImportServerTemplateWizard(this.m_parentShell, this.m_flightRecorderService);
        if (serverTemplate != null) {
            this.updateRecordingTemplate(serverTemplate);
        }
    }

    private void updateRecordingTemplate(RecordingTemplate template) {
        for (RecordingOption templateOption : template.getOptions()) {
            this.m_recordingTemplate.setOption(templateOption);
        }
        this.m_recordingTemplateViewer.setInput(this.m_recordingTemplate);
    }
}

