/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.views;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.NumberField;
import com.jrockit.mc.core.model.fields.StringField;
import com.jrockit.mc.core.model.fields.TimeField;
import com.jrockit.mc.core.model.fields.TimeSpanField;
import com.jrockit.mc.core.ui.fields.AbstractFieldTreeContentProvider;
import com.jrockit.mc.core.ui.fields.FieldToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.views.StateField;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class ControlPanelContentProvider
extends AbstractFieldTreeContentProvider {
    private static final char CONTINUOUS = '\u221e';
    private static int FIELD_COUNTER = 0;
    public static final Field FIELD_NAME = new StringField(FIELD_COUNTER++);
    public static final Field FIELD_STATE = new StateField(FIELD_COUNTER++);
    public static final Field FIELD_START_TIME = new TimeField(FIELD_COUNTER++);
    public static final Field FIELD_DURATION = new TimeSpanField(FIELD_COUNTER++);
    public static final Field FIELD_TIME_REMAINING = new TimeSpanField(FIELD_COUNTER++);
    public static final Field FIELD_IDENTIFIER = new NumberField(FIELD_COUNTER++);
    static final Field[] FIELD_PROTOTYPES = new Field[]{FIELD_NAME, FIELD_STATE, FIELD_START_TIME, FIELD_DURATION, FIELD_TIME_REMAINING, FIELD_IDENTIFIER};
    private Map<IRecordingDescriptor, JvmModel> m_childToParentMap;

    static {
        FieldToolkit.initializeFields((String)"com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.fields", ControlPanelContentProvider.class);
        FIELD_NAME.setWidthWeight(150);
        FIELD_STATE.setWidthWeight(50);
        FIELD_STATE.setVisible(false);
        FIELD_START_TIME.setWidthWeight(75);
        FIELD_START_TIME.setVisible(false);
        FIELD_DURATION.setWidthWeight(50);
        FIELD_DURATION.setVisible(false);
        FIELD_TIME_REMAINING.setWidthWeight(50);
        FIELD_IDENTIFIER.setWidthWeight(50);
        FIELD_IDENTIFIER.setVisible(false);
    }

    public Object[] getColumnObject(Object object) {
        if (object instanceof JvmModel) {
            return this.getJvmModelColumnObjects((JvmModel)object);
        }
        if (object instanceof IRecordingDescriptor) {
            return this.getRecordingDescriptorColumnObjects((IRecordingDescriptor)object);
        }
        assert (false);
        return new Object[0];
    }

    private Object[] getJvmModelColumnObjects(JvmModel jvmModel) {
        Object[] result = new Object[FIELD_COUNTER];
        result[ControlPanelContentProvider.FIELD_NAME.INDEX] = jvmModel.getConnectionHandle().getDescriptor().getName();
        if (!jvmModel.isConnected()) {
            result[ControlPanelContentProvider.FIELD_NAME.INDEX] = NLS.bind((String)Messages.LABEL_RECORDING_SERVER_DISCONNECTED, (Object)result[ControlPanelContentProvider.FIELD_NAME.INDEX]);
        }
        result[ControlPanelContentProvider.FIELD_STATE.INDEX] = "";
        result[ControlPanelContentProvider.FIELD_START_TIME.INDEX] = "";
        result[ControlPanelContentProvider.FIELD_DURATION.INDEX] = "";
        result[ControlPanelContentProvider.FIELD_TIME_REMAINING.INDEX] = "";
        result[ControlPanelContentProvider.FIELD_IDENTIFIER.INDEX] = "";
        return result;
    }

    private Object[] getRecordingDescriptorColumnObjects(IRecordingDescriptor recording) {
        if (this.m_childToParentMap.get(recording).isConnected()) {
            return this.getConnectedRecordingDescriptorColumnObjects(recording);
        }
        return this.getDisconnectedRecordingDescriptorColumnObjects(recording);
    }

    private Object[] getConnectedRecordingDescriptorColumnObjects(IRecordingDescriptor recording) {
        Object[] result = new Object[FIELD_COUNTER];
        result[ControlPanelContentProvider.FIELD_NAME.INDEX] = recording.getName();
        result[ControlPanelContentProvider.FIELD_STATE.INDEX] = recording.getState();
        result[ControlPanelContentProvider.FIELD_START_TIME.INDEX] = this.getRecordingDescriptorStartTime(recording);
        result[ControlPanelContentProvider.FIELD_DURATION.INDEX] = this.getRecordingDescriptorDuration(recording);
        result[ControlPanelContentProvider.FIELD_TIME_REMAINING.INDEX] = this.getRecordingDescriptorTimeRemaining(recording);
        result[ControlPanelContentProvider.FIELD_IDENTIFIER.INDEX] = recording.getId();
        return result;
    }

    private Object[] getDisconnectedRecordingDescriptorColumnObjects(IRecordingDescriptor recording) {
        Object[] result = new Object[FIELD_COUNTER];
        result[ControlPanelContentProvider.FIELD_NAME.INDEX] = recording.getName();
        result[ControlPanelContentProvider.FIELD_STATE.INDEX] = Messages.RECORDING_STATE_UNKNOWN;
        result[ControlPanelContentProvider.FIELD_START_TIME.INDEX] = this.getRecordingDescriptorStartTime(recording);
        result[ControlPanelContentProvider.FIELD_DURATION.INDEX] = this.getRecordingDescriptorDuration(recording);
        result[ControlPanelContentProvider.FIELD_TIME_REMAINING.INDEX] = Messages.RECORDING_DESCRIPTOR_TIME_LEFT_UNKNOWN;
        result[ControlPanelContentProvider.FIELD_IDENTIFIER.INDEX] = recording.getId();
        return result;
    }

    private Object getRecordingDescriptorStartTime(IRecordingDescriptor recording) {
        Date startTime = recording.getStartTime();
        if (startTime != null) {
            return this.getServerTimeAsLocalTime(recording, startTime.getTime());
        }
        return "";
    }

    private Object getRecordingDescriptorDuration(IRecordingDescriptor recording) {
        if (recording.isContinuous()) {
            return Character.valueOf('\u221e');
        }
        long duration = recording.getDuration();
        if (duration < 0L) {
            return "";
        }
        return duration;
    }

    private Object getRecordingDescriptorTimeRemaining(IRecordingDescriptor recording) {
        if (recording.isContinuous()) {
            return Character.valueOf('\u221e');
        }
        if (recording.getState() == IRecordingDescriptor.RecordingState.STOPPED) {
            return 0L;
        }
        return this.calculateTimeRemaining(recording);
    }

    private Object calculateTimeRemaining(IRecordingDescriptor recording) {
        Date startTime = recording.getStartTime();
        long duration = recording.getDuration();
        if (startTime == null || duration < 0L) {
            return Messages.RECORDING_DESCRIPTOR_TIME_LEFT_UNKNOWN;
        }
        long endTime = this.getServerTimeAsLocalTime(recording, startTime.getTime() + duration);
        return this.round(Math.max(endTime - System.currentTimeMillis(), 0L));
    }

    private long getServerTimeAsLocalTime(IRecordingDescriptor recording, long time) {
        IMBeanHelperService service = (IMBeanHelperService)((JvmModel)this.getRowParent(recording)).getConnectionHandle().getService(IMBeanHelperService.class);
        return service != null ? time - service.getApproximateServerTime(0L) : time;
    }

    private Object round(long l) {
        long modulo = l % 1000L;
        if (modulo < 500L) {
            return l - modulo;
        }
        return l + (1000L - modulo);
    }

    public Object[] getRowElements(Object inputElement) {
        if (inputElement instanceof JvmRepository) {
            this.m_childToParentMap = new HashMap<IRecordingDescriptor, JvmModel>();
            return ((JvmRepository)inputElement).getJvmModels().toArray();
        }
        assert (false);
        return new Object[0];
    }

    public Object getRowParent(Object element) {
        return this.m_childToParentMap.get(element);
    }

    protected Object[] getRowChildren(Object parentElement) {
        if (parentElement instanceof JvmModel) {
            JvmModel jvmModel = (JvmModel)parentElement;
            List<IRecordingDescriptor> recordings = jvmModel.getRecordings();
            for (IRecordingDescriptor recording : recordings) {
                this.m_childToParentMap.put(recording, jvmModel);
            }
            return recordings.toArray(new IRecordingDescriptor[recordings.size()]);
        }
        assert (false);
        return new Object[0];
    }

    protected boolean hasRowChildren(Object element) {
        if (element instanceof JvmModel) {
            return this.hasRecordings((JvmModel)element);
        }
        assert (element instanceof IRecordingDescriptor);
        return false;
    }

    private boolean hasRecordings(JvmModel jvmModel) {
        return jvmModel.getRecordings().size() > 0;
    }
}

