/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.flightrecorder.controlpanel.ui.ImportExportToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateComparisonResult;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateComparisonToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRecordingRepository;
import com.jrockit.mc.rjmx.flr.EventTypeSetting;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public final class TemplateRepositoryToolkit {
    private TemplateRepositoryToolkit() {
    }

    public static void findTemplate(TemplateRecordingRepository templateRepository, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) {
        EventTypeSetting[] settings = TemplateRepositoryToolkit.getEventTypeSettings(jvmModel, recordingDescriptor);
        List<RecordingTemplate> existingTemplates = templateRepository.getAllTemplates();
        TemplateComparisonResult bestFit = null;
        for (RecordingTemplate template : existingTemplates) {
            TemplateComparisonResult currentFit = TemplateComparisonToolkit.compareSettingsToTemplate(settings, template, jvmModel.getFlightRecorderService());
            if (currentFit.isCompleteMatch()) {
                templateRepository.setActive(template);
                return;
            }
            bestFit = TemplateRepositoryToolkit.fittest(bestFit, currentFit);
        }
        TemplateRepositoryToolkit.createTemplate(templateRepository, recordingDescriptor, settings, bestFit);
    }

    private static TemplateComparisonResult fittest(TemplateComparisonResult bestFit, TemplateComparisonResult currentFit) {
        if (bestFit == null || currentFit.isMoreEqual(bestFit)) {
            return currentFit;
        }
        return bestFit;
    }

    private static void createTemplate(TemplateRecordingRepository templateRepository, IRecordingDescriptor recordingDescriptor, EventTypeSetting[] settings, TemplateComparisonResult bestFit) {
        if (bestFit.getDifferentPropertiesCount() * 10 < bestFit.getEqualPropertiesCount()) {
            TemplateRepositoryToolkit.createCopyTemplate(templateRepository, bestFit.getTemplate(), bestFit.getUpdatedSettings(), bestFit.getRemovedSettings());
        } else {
            TemplateRepositoryToolkit.createNewTemplate(templateRepository, settings, recordingDescriptor.getName());
        }
    }

    private static void createCopyTemplate(TemplateRecordingRepository templateRepository, RecordingTemplate baseTemplate, EventTypeSetting[] settingsToUpdate, EventTypeSetting[] settingsToRemove) {
        RecordingTemplate template = baseTemplate.createClone();
        template.setName(NLS.bind((String)Messages.RECORDING_TEMPLATE_COPY_NAME, (Object)baseTemplate.getName()));
        template.setModifiable(true);
        ImportExportToolkit.addSettingsToTemplate(template, settingsToUpdate);
        ImportExportToolkit.removeSettingsFromTemplate(template, settingsToRemove);
        templateRepository.add(template, false);
        templateRepository.setActive(template);
    }

    public static void createNewTemplate(TemplateRecordingRepository templateRepository, EventTypeSetting[] settings, String name) {
        RecordingTemplate template = new RecordingTemplate();
        template.setName(NLS.bind((String)Messages.RECORDING_TEMPLATE_LOADED_NAME, (Object)name));
        template.setDescription(NLS.bind((String)Messages.RECORDING_TEMPLATE_LOADED_DESCRIPTION, (Object)name));
        template.setModifiable(true);
        template.getOptions().clear();
        ImportExportToolkit.addSettingsToTemplate(template, settings);
        templateRepository.add(template, false);
        templateRepository.setActive(template);
    }

    private static EventTypeSetting[] getEventTypeSettings(JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) {
        IFlightRecorderService service = jvmModel.getFlightRecorderService();
        try {
            return service.getEventSettings(recordingDescriptor);
        }
        catch (FlightRecorderException e) {
            return new EventTypeSetting[0];
        }
    }
}

