/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TemplateRecordingRepository {
    private final Setting m_setting = new Setting("templateRepository");
    private final List<RecordingTemplate> m_unsavedTemplates = new ArrayList<RecordingTemplate>();

    static {
        PersistenceToolkit.registerFetcher(TemplateRecordingRepository.class, (ISettingFetcher)new ISettingFetcher<TemplateRecordingRepository>(){

            public Setting getSetting(TemplateRecordingRepository templateRecordingRepository) {
                return templateRecordingRepository.m_setting;
            }
        });
    }

    public void remove(RecordingTemplate t) {
        assert (t.isModifiable());
        if (this.isUnsaved(t)) {
            this.getUnsavedTemplates().remove(t);
        } else {
            this.getSavedTemplates().remove(t);
        }
    }

    public void add(RecordingTemplate t, boolean saved) {
        if (saved) {
            this.getSavedTemplates().add(t);
        } else {
            this.getUnsavedTemplates().add(t);
        }
    }

    public void saveTemplate(RecordingTemplate template) {
        if (this.getUnsavedTemplates().remove(template)) {
            this.getSavedTemplates().add(template);
        }
    }

    public void setActive(RecordingTemplate selected) {
        for (RecordingTemplate rt : this.getAllTemplates()) {
            rt.setactive(false);
        }
        selected.setactive(true);
    }

    public RecordingTemplate getActive() {
        for (RecordingTemplate rt : this.getAllTemplates()) {
            if (!rt.isActive()) continue;
            return rt;
        }
        if (this.getSavedTemplates().size() > 0) {
            RecordingTemplate first = this.getSavedTemplates().get(0);
            first.setactive(true);
            return first;
        }
        return null;
    }

    public boolean isAllowedName(String name) {
        for (RecordingTemplate rt : this.getAllTemplates()) {
            if (rt == this.getActive() || !name.equals(rt.getName())) continue;
            return false;
        }
        return true;
    }

    private List<RecordingTemplate> getUnsavedTemplates() {
        return this.m_unsavedTemplates;
    }

    private List<RecordingTemplate> getSavedTemplates() {
        return (List)this.m_setting.getChildObject("templates", new Type(List.class, new Type[]{new Type(RecordingTemplate.class)}));
    }

    public List<RecordingTemplate> getAllTemplates() {
        ArrayList<RecordingTemplate> al = new ArrayList<RecordingTemplate>();
        al.addAll(this.getSavedTemplates());
        al.addAll(this.getUnsavedTemplates());
        return al;
    }

    public boolean isUnsaved(RecordingTemplate template) {
        return this.m_unsavedTemplates.contains(template);
    }
}

