/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateComparisonResult;
import com.jrockit.mc.rjmx.flr.EventTypeSetting;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.flr.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TemplateComparisonToolkit {
    private TemplateComparisonToolkit() {
    }

    public static TemplateComparisonResult compareSettingsToTemplate(EventTypeSetting[] settings, RecordingTemplate template, IFlightRecorderService flightRecorderService) {
        TemplateComparisonResult result = new TemplateComparisonResult(template);
        EventTypeSetting[] templateSettings = template.toRecordingSettings(flightRecorderService);
        Map<String, EventTypeSetting> settingsMap = TemplateComparisonToolkit.createSettingsMap(settings);
        EventTypeSetting[] eventTypeSettingArray = templateSettings;
        int n = templateSettings.length;
        int n2 = 0;
        while (n2 < n) {
            EventTypeSetting templateEvent = eventTypeSettingArray[n2];
            EventTypeSetting event = settingsMap.remove(TemplateComparisonToolkit.getEventPath(templateEvent));
            if (event != null) {
                TemplateComparisonToolkit.compareEvent(event, templateEvent, result);
            } else {
                result.addLackingProperties(templateEvent);
            }
            ++n2;
        }
        for (EventTypeSetting event : settingsMap.values()) {
            result.addAddedProperties(event);
        }
        return result;
    }

    private static Map<String, EventTypeSetting> createSettingsMap(EventTypeSetting[] settings) {
        HashMap<String, EventTypeSetting> settingsMap = new HashMap<String, EventTypeSetting>();
        EventTypeSetting[] eventTypeSettingArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            EventTypeSetting event = eventTypeSettingArray[n2];
            settingsMap.put(TemplateComparisonToolkit.getEventPath(event), event);
            ++n2;
        }
        return settingsMap;
    }

    private static void compareEvent(EventTypeSetting event, EventTypeSetting templateEvent, TemplateComparisonResult result) {
        ArrayList<Option> optionsToUpdate = new ArrayList<Option>();
        Option[] options = (Option[])event.getConfigurableOptions().clone();
        TemplateComparisonToolkit.compareExistingEventOptions(templateEvent, result, optionsToUpdate, options);
        if (optionsToUpdate.size() > 0) {
            result.addDifferingProperties(new EventTypeSetting(event.getMetaData(), optionsToUpdate.toArray(new Option[optionsToUpdate.size()])));
            optionsToUpdate.clear();
        }
        TemplateComparisonToolkit.addRemainingEventOptions(optionsToUpdate, options);
        if (optionsToUpdate.size() > 0) {
            result.addAddedProperties(new EventTypeSetting(event.getMetaData(), optionsToUpdate.toArray(new Option[optionsToUpdate.size()])));
        }
    }

    private static void addRemainingEventOptions(List<Option> optionsToUpdate, Option[] options) {
        Option[] optionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (option != null) {
                optionsToUpdate.add(option);
            }
            ++n2;
        }
    }

    private static void compareExistingEventOptions(EventTypeSetting templateEvent, TemplateComparisonResult result, List<Option> optionsToUpdate, Option[] options) {
        Option[] optionArray = templateEvent.getConfigurableOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option templateOption = optionArray[n2];
            int i = 0;
            while (i < options.length) {
                TemplateComparisonToolkit.compareExistingEventOption(result, optionsToUpdate, options, templateOption, i);
                ++i;
            }
            ++n2;
        }
    }

    private static void compareExistingEventOption(TemplateComparisonResult result, List<Option> optionsToUpdate, Option[] options, Option templateOption, int i) {
        Option option = options[i];
        if (option != null && TemplateComparisonToolkit.getOptionKey(option).equals(TemplateComparisonToolkit.getOptionKey(templateOption))) {
            if (option.getValue().equals(templateOption.getValue())) {
                result.addEqualPropertiesCount(1);
            } else {
                optionsToUpdate.add(option);
            }
            options[i] = null;
        }
    }

    private static String getEventPath(EventTypeSetting event) {
        return event.getMetaData().getPath();
    }

    private static String getOptionKey(Option option) {
        return option.getMetaData().getKey();
    }
}

