/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.rjmx.flr.EventTypeSetting;
import com.jrockit.mc.rjmx.flr.Option;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateComparisonResult {
    private final RecordingTemplate m_template;
    private int m_equalPropertiesCount;
    private int m_differentPropertiesCount;
    private int m_lackingPropertiesCount;
    private int m_addedPropertiesCount;
    private Map<String, EventTypeSetting> m_settingsToUpdate;
    private Map<String, EventTypeSetting> m_settingsToRemove;

    public TemplateComparisonResult(RecordingTemplate template) {
        this.m_template = template;
        this.m_settingsToUpdate = new HashMap<String, EventTypeSetting>();
        this.m_settingsToRemove = new HashMap<String, EventTypeSetting>();
    }

    public RecordingTemplate getTemplate() {
        return this.m_template;
    }

    public EventTypeSetting[] getUpdatedSettings() {
        return this.getSettings(this.m_settingsToUpdate);
    }

    public EventTypeSetting[] getRemovedSettings() {
        return this.getSettings(this.m_settingsToRemove);
    }

    private EventTypeSetting[] getSettings(Map<String, EventTypeSetting> settings) {
        return settings.values().toArray(new EventTypeSetting[settings.size()]);
    }

    public int getEqualPropertiesCount() {
        return this.m_equalPropertiesCount;
    }

    public int getDifferentPropertiesCount() {
        return this.m_differentPropertiesCount;
    }

    public boolean isCompleteMatch() {
        return this.m_differentPropertiesCount == 0 && this.m_lackingPropertiesCount == 0 && this.m_addedPropertiesCount == 0;
    }

    public boolean isMoreEqual(TemplateComparisonResult that) {
        return this.m_equalPropertiesCount > that.m_equalPropertiesCount || this.m_equalPropertiesCount == that.m_equalPropertiesCount && this.isLessDifferent(that);
    }

    private boolean isLessDifferent(TemplateComparisonResult that) {
        return this.m_differentPropertiesCount < that.m_differentPropertiesCount || this.m_differentPropertiesCount == that.m_differentPropertiesCount && this.isLessAltered(that);
    }

    private boolean isLessAltered(TemplateComparisonResult that) {
        return this.m_lackingPropertiesCount < that.m_lackingPropertiesCount || this.m_lackingPropertiesCount == that.m_lackingPropertiesCount && this.m_addedPropertiesCount < that.m_addedPropertiesCount;
    }

    public void addEqualPropertiesCount(int propertiesCount) {
        this.m_equalPropertiesCount += propertiesCount;
    }

    public void addDifferingProperties(EventTypeSetting event) {
        this.m_differentPropertiesCount += event.getConfigurableOptions().length;
        this.addUpdateSettings(event);
    }

    public void addAddedProperties(EventTypeSetting event) {
        this.m_addedPropertiesCount += event.getConfigurableOptions().length;
        this.addUpdateSettings(event);
    }

    public void addLackingProperties(EventTypeSetting event) {
        this.m_lackingPropertiesCount += event.getConfigurableOptions().length;
        this.addLackingSettings(event);
    }

    private void addUpdateSettings(EventTypeSetting event) {
        this.addSettings(event, this.m_settingsToUpdate);
    }

    private void addLackingSettings(EventTypeSetting event) {
        this.addSettings(event, this.m_settingsToRemove);
    }

    private void addSettings(EventTypeSetting event, Map<String, EventTypeSetting> settings) {
        String eventPath = this.getEventPath(event);
        EventTypeSetting existing = settings.get(eventPath);
        if (existing != null) {
            event = new EventTypeSetting(event.getMetaData(), this.updateOptions(existing.getConfigurableOptions(), event.getConfigurableOptions()));
        }
        settings.put(eventPath, event);
    }

    private Option[] updateOptions(Option[] existingOptions, Option[] updatedOptions) {
        HashMap<String, Option> options = new HashMap<String, Option>();
        Option[] optionArray = existingOptions;
        int n = existingOptions.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            options.put(this.getOptionKey(option), option);
            ++n2;
        }
        optionArray = updatedOptions;
        n = updatedOptions.length;
        n2 = 0;
        while (n2 < n) {
            Option updatedOption = optionArray[n2];
            options.put(this.getOptionKey(updatedOption), updatedOption);
            ++n2;
        }
        return options.values().toArray(new Option[options.size()]);
    }

    private String getEventPath(EventTypeSetting event) {
        return event.getMetaData().getPath();
    }

    private String getOptionKey(Option option) {
        return option.getMetaData().getKey();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '[' + this.m_template.getName() + ',' + this.m_equalPropertiesCount + ',' + this.m_differentPropertiesCount + ',' + this.m_lackingPropertiesCount + ',' + this.m_addedPropertiesCount + ']';
    }
}

