/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.LocalizedString;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmEventProperties;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingOption;
import com.jrockit.mc.rjmx.flr.EventTypeSetting;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.flr.Option;
import com.jrockit.mc.rjmx.flr.RecordingSettingsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecordingTemplate {
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String MODIFIABLE = "modifiable";
    private static final String OPTIONS = "options";
    private static final String ACTIVE = "active";
    private final Setting m_setting = new Setting("template");

    static {
        PersistenceToolkit.registerFetcher(RecordingTemplate.class, (ISettingFetcher)new ISettingFetcher<RecordingTemplate>(){

            public Setting getSetting(RecordingTemplate recordingTemplate) {
                return recordingTemplate.m_setting;
            }
        });
    }

    public String getName() {
        return ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).getText();
    }

    public void setName(String name) {
        ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).setText(name);
    }

    public String getDescription() {
        return ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).getText();
    }

    public void setDescription(String description) {
        ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).setText(description);
    }

    public boolean isModifiable() {
        return (Boolean)this.m_setting.getChildObject(MODIFIABLE, Boolean.class);
    }

    public void setModifiable(boolean active) {
        this.m_setting.setChildObject(MODIFIABLE, (Object)active);
    }

    public boolean isActive() {
        return (Boolean)this.m_setting.getChildObject(ACTIVE, Boolean.class);
    }

    public void setactive(boolean active) {
        this.m_setting.setChildObject(ACTIVE, (Object)active);
    }

    public List<RecordingOption> getOptions() {
        return (List)this.m_setting.getChildObject(OPTIONS, new Type(List.class, new Type[]{new Type(RecordingOption.class)}));
    }

    public Map<String, String> getOptionMap() {
        ArrayList<RecordingOption> optionList = new ArrayList<RecordingOption>();
        optionList.addAll(this.getOptions());
        Collections.sort(optionList);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (RecordingOption o : optionList) {
            map.put(o.getFullKeyPath(), o.getValue());
        }
        return map;
    }

    public RecordingOption findOption(String key) {
        for (RecordingOption o : this.getOptions()) {
            if (!o.getFullKeyPath().equals(key)) continue;
            return o;
        }
        return null;
    }

    public void setOption(RecordingOption option) {
        this.removeOption(option);
        this.getOptions().add(option);
    }

    public void removeOption(RecordingOption option) {
        RecordingOption oldOpption = this.findOption(option.getFullKeyPath());
        if (oldOpption != null) {
            this.getOptions().remove(oldOpption);
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        for (RecordingOption ro : this.getOptions()) {
            props.put(ro.getFullKeyPath(), ro.getValue());
        }
        return props;
    }

    public EventTypeSetting[] toRecordingSettings(IFlightRecorderService flightRecorderService) {
        Map<String, String> templateProperties = this.getOptionMap();
        JvmEventProperties serverEventProperties = new JvmEventProperties(flightRecorderService);
        RecordingSettingsBuilder settingsBuilder = new RecordingSettingsBuilder();
        for (Map.Entry<String, String> templateProperty : templateProperties.entrySet()) {
            Option serverProperty = serverEventProperties.getProperty(templateProperty.getKey());
            if (serverProperty == null) continue;
            try {
                settingsBuilder.setOption(serverEventProperties.getEventMetaData(templateProperty.getKey()), serverProperty.getMetaData(), (Object)templateProperty.getValue());
            }
            catch (FlightRecorderException e) {
                ControlPanel.getDefault().getLogger().log(Level.SEVERE, NLS.bind((String)"Unable to store value \"{0}\" for property {1}.", (Object)templateProperty.getValue(), (Object)templateProperty.getKey()));
            }
        }
        return settingsBuilder.build();
    }

    public RecordingTemplate createClone() {
        RecordingTemplate rt = (RecordingTemplate)PersistenceToolkit.createCopy((Object)this);
        rt.m_setting.setChildObject(NAME, (Object)this.createLocalizedStringWithLocalizedTextFragment(this.getName()));
        rt.m_setting.setChildObject(DESCRIPTION, (Object)this.createLocalizedStringWithLocalizedTextFragment(this.getDescription()));
        return rt;
    }

    private LocalizedString createLocalizedStringWithLocalizedTextFragment(String text) {
        LocalizedString ls = new LocalizedString();
        ls.setText(text);
        return ls;
    }
}

