/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import org.eclipse.core.expressions.PropertyTester;

public class RecordingDescriptorTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IRecordingDescriptor) {
            return this.testRecordingDescriptor((IRecordingDescriptor)receiver, property, expectedValue);
        }
        return false;
    }

    private boolean testRecordingDescriptor(IRecordingDescriptor recordingDescriptor, String property, Object expectedValue) {
        if (property.equals("isStopped")) {
            return this.checkStopped(expectedValue, recordingDescriptor);
        }
        if (property.equals("isConnected")) {
            return this.checkConnected(expectedValue, recordingDescriptor);
        }
        if (property.equals("isDebug")) {
            return this.checkDebug(expectedValue);
        }
        return false;
    }

    private boolean checkStopped(Object expectedValue, IRecordingDescriptor recordingDescriptor) {
        return Boolean.valueOf(recordingDescriptor.getState() == IRecordingDescriptor.RecordingState.STOPPED).equals(expectedValue);
    }

    private boolean checkConnected(Object expectedValue, IRecordingDescriptor recordingDescriptor) {
        return Boolean.valueOf(this.isConnected(recordingDescriptor)).equals(expectedValue);
    }

    private boolean isConnected(IRecordingDescriptor recordingDescriptor) {
        IConnectionHandle[] handles;
        IConnectionHandle[] iConnectionHandleArray = handles = RJMXPlugin.getDefault().getConnectionManager().getConnections(recordingDescriptor.getConnectionDescriptor());
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionHandle handle = iConnectionHandleArray[n2];
            if (!handle.isConnected()) {
                return false;
            }
            ++n2;
        }
        return handles.length > 0;
    }

    private boolean checkDebug(Object expectedValue) {
        return expectedValue.equals(Boolean.getBoolean("com.jrockit.mc.debug"));
    }
}

