/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.core.PollManager;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.ConnectionHandleEvent;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IConnectionHandleStateListener;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmRepository
extends Observable {
    PollManager m_pollManager = new PollManager();
    Map<IConnectionDescriptor, JvmModel> m_jvmModels = new HashMap<IConnectionDescriptor, JvmModel>();
    Observer m_jvmModelObserver = new Observer(){

        public void update(Observable o, Object arg) {
            JvmRepository.this.setChanged();
            JvmRepository.this.notifyObservers();
        }
    };

    public JvmRepository() {
        this.addConnectionStateListener();
    }

    private void addConnectionStateListener() {
        RJMXPlugin.getDefault().getConnectionManager().addConnectionHandleStateListener(new IConnectionHandleStateListener(){

            public void onConnectionHandleStateChange(ConnectionHandleEvent e) {
                if (JvmRepository.this.presentInRepository(e.getConnectionHandle())) {
                    JvmRepository.this.setChanged();
                    JvmRepository.this.notifyObservers();
                }
            }
        }, null);
    }

    private boolean presentInRepository(IConnectionHandle connection) {
        IConnectionDescriptor descriptor = connection.getDescriptor();
        JvmModel jvmModel = this.m_jvmModels.get(descriptor);
        return jvmModel != null && jvmModel.getConnectionHandle() == connection;
    }

    public void clear() {
        Collection<JvmModel> jvmModels = this.getJvmModels();
        this.m_jvmModels.clear();
        for (JvmModel jvmModel : jvmModels) {
            jvmModel.dispose();
            this.setChanged();
        }
        this.notifyObservers();
    }

    public void add(List<IConnectionDescriptor> descriptors) throws IOException {
        ArrayList<IConnectionDescriptor> failedConnections = new ArrayList<IConnectionDescriptor>();
        ArrayList<IConnectionDescriptor> noService = new ArrayList<IConnectionDescriptor>();
        Throwable lastException = null;
        for (IConnectionDescriptor descriptor : descriptors) {
            try {
                this.addOrReconnect(descriptor);
            }
            catch (ConnectionException e) {
                failedConnections.add(descriptor);
                lastException = e;
            }
            catch (IOException e) {
                noService.add(descriptor);
                lastException = e;
            }
        }
        this.notifyObservers();
        if (failedConnections.size() > 0 || noService.size() > 0) {
            IOException e = new IOException(this.buildErrorMessage(failedConnections, noService));
            e.initCause(lastException);
            throw e;
        }
    }

    private void addOrReconnect(IConnectionDescriptor descriptor) throws IOException {
        JvmModel jvmModel = this.getJvmModel(descriptor);
        if (jvmModel == null) {
            this.add(descriptor);
        } else if (!jvmModel.isConnected()) {
            this.reconnect(descriptor);
        }
    }

    private String buildErrorMessage(List<IConnectionDescriptor> failedConnections, List<IConnectionDescriptor> noService) {
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append(Messages.NO_SUPPORT_FOR_FLIGHT_RECORDER_INFO_MSG);
        if (failedConnections.size() > 0) {
            msgBuilder.append(NLS.bind((String)Messages.NO_CONNECTION_ESTABLISHED_ERROR_MSG, (Object)this.buildDescriptorList(failedConnections)));
            if (noService.size() > 0) {
                msgBuilder.append("\n\n");
            }
        }
        if (noService.size() > 0) {
            msgBuilder.append(NLS.bind((String)Messages.NO_FLIGHT_RECORDER_SERVICE_FOUND_ERROR_MSG, (Object)this.buildDescriptorList(noService)));
        }
        return msgBuilder.toString();
    }

    private String buildDescriptorList(List<IConnectionDescriptor> descriptors) {
        StringBuilder descriptorsListBuilder = new StringBuilder();
        for (IConnectionDescriptor descriptor : descriptors) {
            descriptorsListBuilder.append('\n');
            descriptorsListBuilder.append(descriptor);
        }
        return descriptorsListBuilder.toString();
    }

    private void reconnect(IConnectionDescriptor descriptor) throws IOException {
        if (!this.flightRecorderServiceExist(descriptor)) {
            throw new IOException(NLS.bind((String)"A flight recorder service for {0} could not be found.", (Object)descriptor));
        }
        this.remove(Arrays.asList(descriptor));
        this.add(descriptor);
    }

    private void add(IConnectionDescriptor descriptor) throws IOException {
        IConnectionHandle connection = RJMXPlugin.getDefault().getConnectionManager().connect(descriptor);
        if (!this.flightRecorderServiceExist(connection)) {
            RJMXPlugin.getDefault().getConnectionManager().disconnect(connection);
            throw new IOException(NLS.bind((String)"A flight recorder service for {0} could not be found.", (Object)descriptor));
        }
        JvmModel jvmModel = new JvmModel(connection, this.m_pollManager);
        this.m_jvmModels.put(connection.getDescriptor(), jvmModel);
        jvmModel.addObserver(this.m_jvmModelObserver);
        jvmModel.update();
        this.setChanged();
    }

    private boolean flightRecorderServiceExist(IConnectionHandle connection) {
        return (IFlightRecorderService)connection.getService(IFlightRecorderService.class) != null;
    }

    private boolean flightRecorderServiceExist(IConnectionDescriptor descriptor) throws ConnectionException {
        IConnectionHandle connection = RJMXPlugin.getDefault().getConnectionManager().connect(descriptor);
        boolean exist = this.flightRecorderServiceExist(connection);
        RJMXPlugin.getDefault().getConnectionManager().disconnect(connection);
        return exist;
    }

    public void remove(List<IConnectionDescriptor> descriptors) {
        for (IConnectionDescriptor descriptor : descriptors) {
            JvmModel jvmModel = this.m_jvmModels.remove(descriptor);
            if (jvmModel == null) continue;
            jvmModel.dispose();
            this.setChanged();
        }
        this.notifyObservers();
    }

    public Collection<JvmModel> getJvmModels() {
        return Collections.unmodifiableCollection(this.m_jvmModels.values());
    }

    public JvmModel getJvmModel(IConnectionDescriptor descriptor) {
        return this.m_jvmModels.get(descriptor);
    }
}

