/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.core.PollManager;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JvmModel
extends Observable
implements PollManager.IPollable {
    public static final String CLIENT_SIDE_FILENAME = "jvmmodel.clientSideFilename";
    private final IConnectionHandle m_connectionHandle;
    private PollManager m_pollManager;
    private volatile List<IRecordingDescriptor> m_recordings = new ArrayList<IRecordingDescriptor>();
    private Map<Long, Properties> m_clientSideProperties;

    public JvmModel(IConnectionHandle connectionHandle, PollManager manager) {
        this.m_connectionHandle = connectionHandle;
        this.m_clientSideProperties = new HashMap<Long, Properties>();
        this.m_pollManager = manager;
        this.m_pollManager.addPollable((PollManager.IPollable)this);
    }

    public void dispose() {
        this.deleteObservers();
        this.m_pollManager.removePollable((PollManager.IPollable)this);
        try {
            RJMXPlugin.getDefault().getConnectionManager().disconnect(this.getConnectionHandle());
        }
        catch (ConnectionException e) {
            ControlPanel.getDefault().getLogger().log(Level.SEVERE, NLS.bind((String)"Could not close connection to {0}.", (Object)this.m_connectionHandle));
        }
    }

    public boolean poll() {
        return this.update();
    }

    public boolean update() {
        if (!this.isConnected()) {
            return false;
        }
        try {
            this.m_recordings = Arrays.asList(this.getFlightRecorderService().getAvailableRecordings());
            this.setChanged();
            this.notifyObservers();
            return true;
        }
        catch (FlightRecorderException e) {
            this.m_pollManager.removePollable((PollManager.IPollable)this);
            try {
                RJMXPlugin.getDefault().getConnectionManager().disconnect(this.getConnectionHandle());
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
            ControlPanel.getDefault().getLogger().log(Level.SEVERE, NLS.bind((String)"Unable to get available recordings for {0}.", (Object)this.m_connectionHandle));
            return false;
        }
    }

    public IConnectionHandle getConnectionHandle() {
        return this.m_connectionHandle;
    }

    public boolean isConnected() {
        return this.getConnectionHandle().isConnected();
    }

    public IFlightRecorderService getFlightRecorderService() {
        return (IFlightRecorderService)this.getConnectionHandle().getService(IFlightRecorderService.class);
    }

    public List<IRecordingDescriptor> getRecordings() {
        return this.m_recordings;
    }

    public IRecordingDescriptor getUpdatedRecording(IRecordingDescriptor oldDescriptor) {
        this.update();
        if (!this.isConnected()) {
            return null;
        }
        List<IRecordingDescriptor> recordings = this.getRecordings();
        int index = recordings.indexOf(oldDescriptor);
        return index >= 0 ? recordings.get(index) : null;
    }

    public Properties getClientSideProperties(IRecordingDescriptor descriptor) {
        return this.m_clientSideProperties.get(descriptor.getId());
    }

    public void setClientSideProperties(IRecordingDescriptor descriptor, Properties properties) {
        this.m_clientSideProperties.put(descriptor.getId(), properties);
    }

    public String getClientSideProperty(IRecordingDescriptor descriptor, String key) {
        Properties properties = this.getClientSideProperties(descriptor);
        if (properties == null) {
            return null;
        }
        return properties.getProperty(key);
    }

    public void setClientSideProperty(IRecordingDescriptor descriptor, String key, String value) {
        Properties properties = this.getClientSideProperties(descriptor);
        if (properties == null) {
            properties = new Properties();
            this.setClientSideProperties(descriptor, properties);
        }
        properties.setProperty(key, value);
    }
}

