/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.rjmx.flr.EventTypeMetadata;
import com.jrockit.mc.rjmx.flr.EventTypeSetting;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.flr.Option;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JvmEventProperties {
    public static final String ENABLED_PROPERTY = "enabled";
    public static final String REQUEST_PERIOD_PROPERTY = "requestPeriod";
    public static final String STACKTRACE_PROPERTY = "stacktrace";
    public static final String THRESHOLD_PROPERTY = "threshold";
    private static final Map<String, String> DEFINED_PROPERTIES = new HashMap<String, String>();
    private final Map<String, EventTypeMetadata> m_propertyMetadata = new HashMap<String, EventTypeMetadata>();
    private final Map<String, Option> m_properties = new HashMap<String, Option>();

    static {
        DEFINED_PROPERTIES.put(REQUEST_PERIOD_PROPERTY, "isRequestable");
        DEFINED_PROPERTIES.put(STACKTRACE_PROPERTY, "isStackTraceAvailable");
        DEFINED_PROPERTIES.put(THRESHOLD_PROPERTY, "isTimed");
    }

    public JvmEventProperties(IFlightRecorderService service) {
        this.initProperties(service);
    }

    private void initProperties(IFlightRecorderService service) {
        try {
            EventTypeSetting[] eventTypeSettingArray = service.getCurrentEventTypeSettings();
            int n = eventTypeSettingArray.length;
            int n2 = 0;
            while (n2 < n) {
                EventTypeSetting event = eventTypeSettingArray[n2];
                this.addProperties(event.getMetaData(), event.getConfigurableOptions());
                ++n2;
            }
        }
        catch (FlightRecorderException e) {
            e.printStackTrace();
        }
    }

    private void addProperties(EventTypeMetadata eventMetadata, Option[] configurableProperties) {
        String path = this.createEventPath(eventMetadata);
        Option[] optionArray = configurableProperties;
        int n = configurableProperties.length;
        int n2 = 0;
        while (n2 < n) {
            Option property = optionArray[n2];
            String key = property.getMetaData().getKey();
            if (key.equals(ENABLED_PROPERTY)) {
                this.addProperty(path, eventMetadata, property);
            } else if (this.metadataSupports(eventMetadata, DEFINED_PROPERTIES.get(key))) {
                this.addProperty(path, eventMetadata, property);
            }
            ++n2;
        }
    }

    private String createEventPath(EventTypeMetadata eventMetadata) {
        return eventMetadata.getPath().replace('/', '.');
    }

    private boolean metadataSupports(EventTypeMetadata eventMetadata, String propertyMetaDataKey) {
        if (propertyMetaDataKey == null) {
            return false;
        }
        Option propertyMetaData = this.findPropertyMetaData(eventMetadata, propertyMetaDataKey);
        if (propertyMetaData != null) {
            return propertyMetaData.getValue().equals(Boolean.TRUE);
        }
        return false;
    }

    private Option findPropertyMetaData(EventTypeMetadata eventMetadata, String propertyMetaDataKey) {
        Option[] optionArray = eventMetadata.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option propertyMetaData = optionArray[n2];
            if (propertyMetaData.getMetaData().getKey().equals(propertyMetaDataKey)) {
                return propertyMetaData;
            }
            ++n2;
        }
        return null;
    }

    private void addProperty(String eventPath, EventTypeMetadata eventMetadata, Option property) {
        String propertyPath = this.createPropertyPath(eventPath, property.getMetaData().getKey());
        this.m_propertyMetadata.put(propertyPath, eventMetadata);
        this.m_properties.put(propertyPath, property);
    }

    private String createPropertyPath(String eventPath, String propertyKey) {
        return String.valueOf(eventPath) + '.' + propertyKey;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, Option> entry : this.m_properties.entrySet()) {
            properties.put(entry.getKey(), entry.getValue().getValue().toString());
        }
        return properties;
    }

    public Option getProperty(String property) {
        return this.m_properties.get(property);
    }

    public EventTypeMetadata getEventMetaData(String property) {
        return this.m_propertyMetadata.get(property);
    }
}

