/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.jobs;

import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.DumpRecordingJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;

public class WaitForRecordingCompletedJob
extends Job {
    private static final long NORMAL_DELAY = 5000L;
    private final IWorkbenchWindow m_window;
    private final JvmModel m_jvmModel;
    private IRecordingDescriptor m_recordingDescriptor;
    private volatile boolean m_canceling;

    public WaitForRecordingCompletedJob(IWorkbenchWindow window, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) {
        super(recordingDescriptor.getName());
        this.m_window = window;
        this.m_jvmModel = jvmModel;
        this.m_recordingDescriptor = recordingDescriptor;
    }

    public boolean belongsTo(Object family) {
        return family instanceof IRecordingDescriptor && family.equals(this.m_recordingDescriptor);
    }

    protected void canceling() {
        this.m_canceling = true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        int timeRun = 0;
        int duration = this.updateDuration(progress, 0, timeRun);
        long startTime = this.getServerTimeAsLocalTime(this.m_recordingDescriptor.getStartTime().getTime());
        while (true) {
            this.m_recordingDescriptor = this.m_jvmModel.getUpdatedRecording(this.m_recordingDescriptor);
            if (this.m_recordingDescriptor == null) {
                progress.done();
                return this.statusForNonExistentRecording();
            }
            if (this.m_canceling && this.m_recordingDescriptor.getState() != IRecordingDescriptor.RecordingState.STOPPED) {
                this.stopRecording();
            } else if (this.m_recordingDescriptor.getState() == IRecordingDescriptor.RecordingState.STOPPED) {
                progress.done();
                return this.statusForFinishedRecording();
            }
            timeRun = this.updateTimeRun(progress, timeRun, startTime);
            duration = this.updateDuration(progress, duration, timeRun);
            this.sleepJob();
        }
    }

    private void sleepJob() {
        try {
            Thread.sleep(this.calcSleepTime());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int updateDuration(SubMonitor progress, int duration, int timeRun) {
        int newDuration = this.calculateSeconds(this.m_recordingDescriptor.getDuration());
        if (newDuration != duration) {
            progress.setWorkRemaining(newDuration - timeRun);
            duration = newDuration;
        }
        return duration;
    }

    private int updateTimeRun(SubMonitor progress, int timeRun, long startTime) {
        int currentTimeRun = this.calculateSeconds(System.currentTimeMillis() - startTime);
        if (currentTimeRun > timeRun) {
            progress.worked(currentTimeRun - timeRun);
            timeRun = currentTimeRun;
        }
        return timeRun;
    }

    private int calculateSeconds(long ms) {
        return (int)Math.min(ms / 1000L, Integer.MAX_VALUE);
    }

    private void stopRecording() {
        try {
            this.m_jvmModel.getFlightRecorderService().stop(this.m_recordingDescriptor);
        }
        catch (FlightRecorderException flightRecorderException) {
            // empty catch block
        }
    }

    private IStatus statusForNonExistentRecording() {
        if (!this.m_canceling) {
            return StatusFactory.createErr((String)NLS.bind((String)Messages.WAIT_FOR_RECORDING_COMPLETED_JOB_UNAVAILABLE_ERROR_MSG, (Object)this.m_recordingDescriptor.getName()));
        }
        return StatusFactory.createOk((String)NLS.bind((String)Messages.WAIT_FOR_RECORDING_COMPLETED_JOB_CLOSED_MSG, (Object)this.m_recordingDescriptor));
    }

    private IStatus statusForFinishedRecording() {
        String filename = this.m_jvmModel.getClientSideProperty(this.m_recordingDescriptor, "jvmmodel.clientSideFilename");
        if (filename == null) {
            return StatusFactory.createErr((String)NLS.bind((String)Messages.WAIT_FOR_RECORDING_COMPLETED_JOB_UNAVAILABLE_FILENAME_MSG, (Object)this.m_recordingDescriptor.getName()));
        }
        DumpRecordingJob dumpJob = new DumpRecordingJob(this.m_window, this.m_jvmModel, this.m_recordingDescriptor, (IPath)new Path(filename));
        dumpJob.schedule();
        return StatusFactory.createOk((String)NLS.bind((String)Messages.WAIT_FOR_RECORDING_COMPLETED_JOB_SUCCESS_MSG, (Object)this.m_recordingDescriptor.getName()));
    }

    private long calcSleepTime() {
        Date startTime = this.m_recordingDescriptor.getStartTime();
        long duration = this.m_recordingDescriptor.getDuration();
        if (startTime != null && duration > 0L && this.getServerTimeAsLocalTime(startTime.getTime() + duration) >= System.currentTimeMillis()) {
            return 2500L;
        }
        return 5000L;
    }

    private long getServerTimeAsLocalTime(long time) {
        IMBeanHelperService service = (IMBeanHelperService)this.m_jvmModel.getConnectionHandle().getService(IMBeanHelperService.class);
        return time - service.getApproximateServerTime(0L);
    }
}

