/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.jobs;

import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.WaitForRecordingCompletedJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.rjmx.flr.EventTypeSetting;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateRecordingJob
extends Job {
    private final IWorkbenchWindow m_window;
    private final JvmModel m_jvmModel;
    private final IRecordingDescriptor m_recordingDescriptor;
    private final IPath m_path;
    private final Map<?, ?> m_recordingOptions;
    private final EventTypeSetting[] m_recordingSettings;

    public UpdateRecordingJob(IWorkbenchWindow window, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor, IPath path, Map<?, ?> recordingOptions, EventTypeSetting[] recordingSettings) {
        super(NLS.bind((String)Messages.UPDATE_RECORDING_JOB_NAME, (Object)recordingDescriptor.getName()));
        this.m_window = window;
        this.m_jvmModel = jvmModel;
        this.m_recordingDescriptor = recordingDescriptor;
        this.m_path = path;
        this.m_recordingOptions = recordingOptions;
        this.m_recordingSettings = recordingSettings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.updateRecording();
            this.updateJob();
            return StatusFactory.createOk((String)Messages.UPDATE_RECORDING_JOB_SUCCESS_MSG);
        }
        catch (FlightRecorderException e) {
            return StatusFactory.createErr((String)NLS.bind((String)Messages.UPDATE_RECORDING_JOB_SERVICE_ERROR_MSG, (Object)this.m_recordingDescriptor.getName()));
        }
    }

    private void updateRecording() throws FlightRecorderException {
        this.m_jvmModel.setClientSideProperty(this.m_recordingDescriptor, "jvmmodel.clientSideFilename", this.m_path.toString());
        IFlightRecorderService flightRecorderService = this.m_jvmModel.getFlightRecorderService();
        flightRecorderService.updateRecordingOptions(this.m_recordingDescriptor, this.m_recordingOptions);
        flightRecorderService.updateEventSettings(this.m_recordingDescriptor, this.m_recordingSettings);
    }

    private void updateJob() {
        IRecordingDescriptor updatedRecordingDescriptor = this.m_jvmModel.getUpdatedRecording(this.m_recordingDescriptor);
        if (this.recordingChangedFromContinuousToFixedDuration(updatedRecordingDescriptor)) {
            new WaitForRecordingCompletedJob(this.m_window, this.m_jvmModel, updatedRecordingDescriptor).schedule();
        } else if (this.recordingChangedFromFixedDurationToContinuous(updatedRecordingDescriptor)) {
            Job.getJobManager().cancel((Object)this.m_recordingDescriptor);
        }
    }

    private boolean recordingChangedFromContinuousToFixedDuration(IRecordingDescriptor updatedRecordingDescriptor) {
        return this.m_recordingDescriptor.getDuration() == 0L && updatedRecordingDescriptor.getDuration() > 0L;
    }

    private boolean recordingChangedFromFixedDurationToContinuous(IRecordingDescriptor updatedRecordingDescriptor) {
        return this.m_recordingDescriptor.getDuration() > 0L && updatedRecordingDescriptor.getDuration() == 0L;
    }
}

