/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.jobs;

import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.WaitForRecordingCompletedJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.rjmx.flr.EventTypeSetting;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StartRecordingJob
extends Job {
    private final IWorkbenchWindow m_window;
    private final JvmModel m_jvmModel;
    private final Map<?, ?> m_recordingOptions;
    private final EventTypeSetting[] m_recordingSettings;
    private final IPath m_path;

    public StartRecordingJob(IWorkbenchWindow window, JvmModel jvmModel, String name, Map<?, ?> recordingOptions, EventTypeSetting[] recordingSettings, IPath path) {
        super(NLS.bind((String)Messages.START_RECORDING_JOB_NAME, (Object)name));
        this.m_window = window;
        this.m_jvmModel = jvmModel;
        this.m_recordingOptions = recordingOptions;
        this.m_recordingSettings = recordingSettings;
        this.m_path = path;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            IRecordingDescriptor startedRecording = this.startRecording();
            if (startedRecording == null) {
                return StatusFactory.createErr((String)Messages.START_RECORDING_JOB_SERVICE_ERROR_MSG);
            }
            this.m_jvmModel.setClientSideProperty(startedRecording, "jvmmodel.clientSideFilename", this.m_path.toString());
            this.m_jvmModel.update();
            if (!startedRecording.isContinuous()) {
                new WaitForRecordingCompletedJob(this.m_window, this.m_jvmModel, startedRecording).schedule();
            }
            return StatusFactory.createOk((String)Messages.START_RECORDING_JOB_SUCCESS_MSG);
        }
        catch (FlightRecorderException e) {
            return StatusFactory.createErr((String)Messages.START_RECORDING_JOB_SERVICE_ERROR_MSG, (Throwable)e, (boolean)false);
        }
    }

    private IRecordingDescriptor startRecording() throws FlightRecorderException {
        IFlightRecorderService flightRecorderService = this.m_jvmModel.getFlightRecorderService();
        return flightRecorderService != null ? flightRecorderService.start(this.m_recordingOptions, this.m_recordingSettings) : null;
    }
}

