/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.jobs;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.OpenRecordingFileJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;

public final class DumpRecordingJob
extends Job {
    private final IWorkbenchWindow m_window;
    private final JvmModel m_jvmModel;
    private final IRecordingDescriptor m_recordingDescriptor;
    private final IPath m_savePath;
    private final Date m_startTime;
    private final Date m_endTime;

    public DumpRecordingJob(IWorkbenchWindow window, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor, IPath savePath) {
        this(window, jvmModel, recordingDescriptor, savePath, null, null);
    }

    public DumpRecordingJob(IWorkbenchWindow window, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor, IPath savePath, Date startTime, Date endTime) {
        super(NLS.bind((String)Messages.DUMP_RECORDING_JOB_NAME, (Object)recordingDescriptor.getName()));
        this.m_window = window;
        this.m_jvmModel = jvmModel;
        this.m_recordingDescriptor = recordingDescriptor;
        this.m_savePath = savePath;
        this.m_startTime = startTime;
        this.m_endTime = endTime;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            boolean removeFinishedRecording = FlightRecorderUI.getDefault().removeFinishedRecordings();
            InputStream is = this.m_startTime != null ? this.m_jvmModel.getFlightRecorderService().openStream(this.m_recordingDescriptor, this.m_startTime, this.m_endTime, removeFinishedRecording) : this.m_jvmModel.getFlightRecorderService().openStream(this.m_recordingDescriptor, removeFinishedRecording);
            IPath actualSavePath = CorePlugin.getDefault().getIDESupport().writeToFile(this.m_window, this.m_savePath, is, monitor);
            is.close();
            this.possibleCloseControlPanelView();
            OpenRecordingFileJob openJob = new OpenRecordingFileJob(this.m_window, actualSavePath);
            openJob.schedule();
            this.m_jvmModel.update();
            return StatusFactory.createOk((String)Messages.DUMP_RECORDING_JOB_SUCCESS_MSG);
        }
        catch (FlightRecorderException e) {
            return StatusFactory.createErr((String)NLS.bind((String)Messages.DUMP_RECORDING_JOB_SERVICE_ERROR_MSG, (Object)this.m_recordingDescriptor.getName()), (Throwable)e, (boolean)false);
        }
        catch (IOException e) {
            return StatusFactory.createErr((String)NLS.bind((String)Messages.DUMP_RECORDING_JOB_IO_ERROR_MSG, (Object)this.m_recordingDescriptor.getName()), (Throwable)e, (boolean)false);
        }
    }

    private void possibleCloseControlPanelView() {
        if (FlightRecorderUI.getDefault().closeControlPanelOnRecordingEnd()) {
            DisplayToolkit.safeAsyncExec((Display)this.m_window.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    IViewPart findView = DumpRecordingJob.this.m_window.getActivePage().findView("com.jrockit.mc.flightrecorder.controlpanel.ui.views.ControlPanelView");
                    if (findView != null) {
                        DumpRecordingJob.this.m_window.getActivePage().hideView(findView);
                    }
                }
            });
        }
    }
}

