/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.jobs;

import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.DumpRecordingHandler;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.ConnectionDescriptorJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpDefaultRecordingJob
extends ConnectionDescriptorJob {
    public DumpDefaultRecordingJob(IWorkbenchWindow workbenchWindow, List<IConnectionDescriptor> descriptors) {
        super(Messages.DUMP_DEFAULT_RECORDING_JOB_NAME, workbenchWindow, null, descriptors);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = this.addDescriptorsToJvmRepository();
        JvmModel jvmModel = this.getJvmModel(0);
        if (jvmModel != null && jvmModel.isConnected()) {
            return this.dumpDefaultRecording(jvmModel);
        }
        return status;
    }

    private IStatus dumpDefaultRecording(final JvmModel jvmModel) {
        for (final IRecordingDescriptor recording : jvmModel.getRecordings()) {
            if (recording.getId() != 0L) continue;
            DisplayToolkit.safeAsyncExec((Widget)this.getWorkbenchWindow().getShell(), (Runnable)new Runnable(){

                public void run() {
                    new DumpRecordingHandler().dumpRecordingWizard(DumpDefaultRecordingJob.this.getWorkbenchWindow(), jvmModel, recording);
                }
            });
            return StatusFactory.createOk((String)Messages.DUMP_DEFAULT_RECORDING_JOB_SUCCESS_MSG);
        }
        DialogToolkit.showErrorDialogAsync((Display)this.getWorkbenchWindow().getShell().getDisplay(), (String)Messages.DUMP_DEFAULT_RECORDING_ERROR_TITLE, (String)NLS.bind((String)Messages.DUMP_DEFAULT_RECORDING_ERROR_MSG, (Object)jvmModel.getConnectionHandle().getDescriptor()));
        return StatusFactory.createOk((String)Messages.DUMP_DEFAULT_RECORDING_JOB_SUCCESS_MSG);
    }
}

