/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.jobs;

import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.views.ControlPanelView;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionDescriptorJob
extends Job {
    private final IWorkbenchWindow m_window;
    private final ControlPanelView m_controlPanelView;
    private final List<IConnectionDescriptor> m_descriptors;

    protected ConnectionDescriptorJob(String name, IWorkbenchWindow workbenchWindow, ControlPanelView controlPanelView, List<IConnectionDescriptor> descriptors) {
        super(name);
        this.m_window = workbenchWindow;
        this.m_controlPanelView = controlPanelView;
        this.m_descriptors = descriptors;
    }

    protected final IStatus addDescriptorsToJvmRepository() {
        try {
            ControlPanel.getDefault().getJvmRepository().add(this.m_descriptors);
        }
        catch (IOException e) {
            DialogToolkit.showExceptionDialogAsync((Display)this.m_window.getShell().getDisplay(), (String)Messages.OPEN_FLIGHT_RECORDER_VIEW_ERROR_TITLE, (String)e.getMessage(), (Throwable)e.getCause());
        }
        if (this.m_controlPanelView != null) {
            this.m_controlPanelView.expandAllRecordings(this.getWorkbenchWindow().getShell().getDisplay());
        }
        return StatusFactory.createOk((String)Messages.CONNECTION_DESCRIPTOR_JOB_SUCCESS_MSG);
    }

    protected final JvmModel getJvmModel(int index) {
        if (index >= 0 && index < this.m_descriptors.size()) {
            return ControlPanel.getDefault().getJvmRepository().getJvmModel(this.m_descriptors.get(index));
        }
        return null;
    }

    protected final IWorkbenchWindow getWorkbenchWindow() {
        return this.m_window;
    }
}

