/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.actions;

import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.StartRecordingJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardPage;
import com.jrockit.mc.rjmx.flr.EventTypeSetting;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.flr.RecordingOptionsBuilder;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchWindow;

public final class ShowWizardAction
extends Action {
    private static final int DIALOG_MAX_HEIGHT = 700;
    private static final int DIALOG_MIN_HEIGHT = 600;
    private static final int DIALOG_MAX_WIDTH = 600;
    private static final int DIALOG_MIN_WIDTH = 500;
    private final JvmModel m_jvmModel;
    private final IWorkbenchWindow m_window;

    public ShowWizardAction(JvmModel jvmModel, IWorkbenchWindow window) {
        super(Messages.START_RECORDING_WIZARD_ACTION_TEXT);
        this.setImageDescriptor(ControlPanel.getDefault().getMCImageDescriptor("FLR_on.gif"));
        this.m_jvmModel = jvmModel;
        this.m_window = window;
    }

    public void run() {
        RecordingWizardPage rp = new RecordingWizardPage(this.m_jvmModel.getFlightRecorderService());
        OnePageWizardDialog dialog = new OnePageWizardDialog(this.m_window.getShell(), (IWizardPage)rp);
        dialog.setWidthConstaint(500, 600);
        dialog.setHeightConstraint(600, 700);
        if (dialog.open() == 0) {
            this.startRecording(rp);
        }
    }

    private void startRecording(RecordingWizardPage rp) {
        RecordingOptionsBuilder builder = new RecordingOptionsBuilder().name(rp.getName());
        if (rp.isFixedRecording()) {
            builder.duration(rp.getDuration()).maxSize(0L).maxAge(0L).toDisk(true);
        } else {
            builder.duration(0L);
            if (rp.getMaxSize() != -1L) {
                builder.maxSize(rp.getMaxSize());
            }
            if (rp.getMaxAge() != -1L) {
                builder.maxAge(rp.getMaxAge());
            }
        }
        Map recordingOptions = builder.build();
        EventTypeSetting[] recordingSettings = this.buildRecordingSettings(rp);
        StartRecordingJob sr = new StartRecordingJob(this.m_window, this.m_jvmModel, rp.getName(), recordingOptions, recordingSettings, rp.getPath());
        sr.schedule();
    }

    private EventTypeSetting[] buildRecordingSettings(RecordingWizardPage rp) {
        IFlightRecorderService flightRecorderService = this.m_jvmModel.getFlightRecorderService();
        if (flightRecorderService != null) {
            return rp.getTemplate().toRecordingSettings(flightRecorderService);
        }
        return new EventTypeSetting[0];
    }
}

