/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.actions;

import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.RecordingDescriptorHandler;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.rjmx.flr.EventTypeMetadata;
import com.jrockit.mc.rjmx.flr.EventTypeSetting;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.flr.Option;
import com.jrockit.mc.rjmx.flr.OptionMetadata;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;

public class PrintRecordingDescriptorHandler
extends RecordingDescriptorHandler {
    private static final String NORMAL_INDENT = "  ";

    public void handleRecordingDescriptor(IWorkbenchPart part, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) {
        PrintStream oldOut = System.err;
        PrintStream newOut = null;
        if ((newOut = this.createNewOutputStream(newOut)) != null) {
            System.setErr(newOut);
            this.printRecordingDescriptor(newOut, jvmModel, recordingDescriptor);
            System.setErr(oldOut);
            newOut.close();
        } else {
            this.printRecordingDescriptor(System.err, jvmModel, recordingDescriptor);
        }
    }

    private PrintStream createNewOutputStream(PrintStream newOut) {
        try {
            String fileName = System.getProperty("com.jrockit.mc.flightrecorder.controlpanel.ui.printRecordingFileName");
            if (fileName != null) {
                newOut = new PrintStream(new FileOutputStream(fileName));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return newOut;
    }

    private void printRecordingDescriptor(OutputStream out, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) {
        this.printRecordingDescriptor(new PrintWriter(out), jvmModel, recordingDescriptor);
    }

    private void printRecordingDescriptor(PrintWriter writer, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) {
        try {
            this.printRecordingDescriptor(writer, recordingDescriptor);
            this.printRecordingOptions(writer, jvmModel, recordingDescriptor);
            this.printEventSettings(writer, jvmModel, recordingDescriptor);
            this.printAvailableRecordingOptions(writer, jvmModel);
            this.printAvailableEventTypes(writer, jvmModel);
            this.printCurrentEventTypeSettings(writer, jvmModel);
            writer.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void printRecordingDescriptor(PrintWriter writer, IRecordingDescriptor recordingDescriptor) {
        writer.printf("id=%d%n", recordingDescriptor.getId());
        writer.printf("name=%s%n", recordingDescriptor.getName());
        writer.printf("state=%s%n", recordingDescriptor.getState());
        writer.printf("options=%n", new Object[0]);
        for (Map.Entry entry : recordingDescriptor.getOptions().entrySet()) {
            writer.printf("\t%s=%s%s%n", entry.getKey(), entry.getValue(), entry.getValue() != null ? NLS.bind((String)" ({0})", entry.getValue().getClass()) : "");
        }
        writer.printf("connectionDescriptor=%s%n", recordingDescriptor.getConnectionDescriptor());
        writer.printf("objectName=%s%n", recordingDescriptor.getObjectName());
        writer.printf("dataStartTime=%tc%n", recordingDescriptor.getDataStartTime());
        writer.printf("dataEndTime=%tc%n", recordingDescriptor.getDataEndTime());
    }

    private void printRecordingOptions(PrintWriter writer, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) throws FlightRecorderException {
        Option[] recordingOptions = jvmModel.getFlightRecorderService().getRecordingOptions(recordingDescriptor);
        writer.printf("getRecordingOptions(recordingDescriptor)=%n", new Object[0]);
        int i = 0;
        while (i < recordingOptions.length) {
            writer.printf("\t[%d]\t%s%n", i, recordingOptions[i]);
            ++i;
        }
    }

    private void printEventSettings(PrintWriter writer, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) throws FlightRecorderException {
        EventTypeSetting[] eventSettings = jvmModel.getFlightRecorderService().getEventSettings(recordingDescriptor);
        writer.printf("getEventSettings(recordingDescriptor)=%n", new Object[0]);
        int i = 0;
        while (i < eventSettings.length) {
            writer.printf("\t[%d]\t%s%n", i, eventSettings[i]);
            ++i;
        }
    }

    private void printAvailableRecordingOptions(PrintWriter writer, JvmModel jvmModel) throws FlightRecorderException {
        OptionMetadata[] optionMetadata = jvmModel.getFlightRecorderService().getAvailableRecordingOptions();
        writer.printf("getAvailableRecordingOptions()=%n", new Object[0]);
        int i = 0;
        while (i < optionMetadata.length) {
            writer.printf("\t[%d]\t%s%n", i, optionMetadata[i]);
            ++i;
        }
    }

    private void printAvailableEventTypes(PrintWriter writer, JvmModel jvmModel) throws FlightRecorderException {
        EventTypeMetadata[] eventTypeMetadata = jvmModel.getFlightRecorderService().getAvailableEventTypes();
        writer.printf("getAvailableEventTypes()=%n", new Object[0]);
        int i = 0;
        while (i < eventTypeMetadata.length) {
            writer.printf("\t[%d]\t%s%n", i, this.toString(eventTypeMetadata[i], "\t\t"));
            ++i;
        }
    }

    private void printCurrentEventTypeSettings(PrintWriter writer, JvmModel jvmModel) throws FlightRecorderException {
        EventTypeSetting[] eventTypeSettings = jvmModel.getFlightRecorderService().getCurrentEventTypeSettings();
        writer.printf("getCurrentEventTypeSettings()=%n", new Object[0]);
        int i = 0;
        while (i < eventTypeSettings.length) {
            writer.printf("\t[%d]\t%s%n", i, this.toString(eventTypeSettings[i], "\t\t"));
            ++i;
        }
    }

    private String toString(EventTypeSetting eventTypeSetting, String indent) {
        indent = String.valueOf(indent) + NORMAL_INDENT;
        return NLS.bind((String)"EventTypeSetting[\n{0}metaData={1},\n{0}options={1}]", (Object[])new Object[]{indent, this.toString(eventTypeSetting.getMetaData(), indent), this.toString(eventTypeSetting.getConfigurableOptions(), indent)});
    }

    private String toString(EventTypeMetadata eventTypeMetadata, String indent) {
        indent = String.valueOf(indent) + NORMAL_INDENT;
        return NLS.bind((String)"EventTypeMetadata[\n{0}path={1},\n{0}id={2},\n{0}uri={3},\n{0}options={4}]", (Object[])new Object[]{indent, eventTypeMetadata.getPath(), eventTypeMetadata.getId(), eventTypeMetadata.getURI(), this.toString(eventTypeMetadata.getOptions(), indent)});
    }

    private String toString(Option[] options, String indent) {
        indent = String.valueOf(indent) + NORMAL_INDENT;
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        int i = 0;
        while (i < options.length) {
            if (i > 0) {
                builder.append(indent);
            }
            builder.append(this.toString(options[i], indent));
            if (i < options.length - 1) {
                builder.append(",\n");
            }
            ++i;
        }
        builder.append(']');
        return builder.toString();
    }

    private String toString(Option option, String indent) {
        indent = String.valueOf(indent) + NORMAL_INDENT;
        return NLS.bind((String)"Option[\n{0}key={1},\n{0}value={2},\n{0}metaData={3}]", (Object[])new Object[]{indent, option.getMetaData().getKey(), option.getValue(), this.toString(option.getMetaData(), indent)});
    }

    private String toString(OptionMetadata metaData, String indent) {
        indent = String.valueOf(indent) + NORMAL_INDENT;
        return NLS.bind((String)"OptionMetaData[\n{0}key={1},\n{0}description={2},\n{0}type={3},\n{0}min={4},\n{0}max={5},\n{0}defaultValue={6},\n{0}contentType={7}]", (Object[])new Object[]{indent, metaData.getKey(), metaData.getDescription(), metaData.getType(), metaData.getMin(), metaData.getMax(), metaData.getDefaultValue(), metaData.getContentType()});
    }
}

