/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.actions;

import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.RecordingDescriptorHandler;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.UpdateRecordingJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardPage;
import com.jrockit.mc.rjmx.flr.EventTypeSetting;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.flr.RecordingOptionsBuilder;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class EditRecordingHandler
extends RecordingDescriptorHandler {
    private static final int MAX_DIALOG_HEIGHT = 700;
    private static final int MIN_DIALOG_HEIGHT = 600;
    private static final int MAX_DIALOG_WIDTH = 600;
    private static final int MIN_DIALOG_WIDTH = 500;

    public void handleRecordingDescriptor(IWorkbenchPart part, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) {
        this.editRecordingWizard(part.getSite().getWorkbenchWindow(), jvmModel, recordingDescriptor);
    }

    private void editRecordingWizard(IWorkbenchWindow window, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) {
        RecordingWizardPage rp = new RecordingWizardPage(jvmModel, recordingDescriptor);
        OnePageWizardDialog dialog = new OnePageWizardDialog(window.getShell(), (IWizardPage)rp);
        dialog.setHeightConstraint(600, 700);
        dialog.setWidthConstaint(500, 600);
        if (dialog.open() == 0) {
            this.editRecording(window, jvmModel, recordingDescriptor, rp);
        }
    }

    private void editRecording(IWorkbenchWindow window, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor, RecordingWizardPage rp) {
        RecordingOptionsBuilder builder = new RecordingOptionsBuilder().name(recordingDescriptor.getName()).toDisk(true);
        if (rp.isFixedRecording()) {
            builder.duration(rp.getDuration()).maxSize(0L).maxAge(0L);
        } else {
            builder.duration(0L);
            if (rp.getMaxSize() != -1L) {
                builder.maxSize(rp.getMaxSize());
            }
            if (rp.getMaxAge() != -1L) {
                builder.maxAge(rp.getMaxAge());
            }
        }
        Map recordingOptions = builder.build();
        EventTypeSetting[] recordingSettings = rp.getTemplate().toRecordingSettings(jvmModel.getFlightRecorderService());
        UpdateRecordingJob updateJob = new UpdateRecordingJob(window, jvmModel, recordingDescriptor, rp.getPath(), recordingOptions, recordingSettings);
        updateJob.schedule();
    }
}

