/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.actions;

import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.views.ControlPanelView;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConnectionDescriptorAction
extends Action
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    private final List<IConnectionDescriptor> m_connectionDescriptors = new ArrayList<IConnectionDescriptor>();
    private IWorkbenchWindow m_window;

    ConnectionDescriptorAction() {
    }

    public void init(IViewPart view) {
        this.m_window = view.getSite().getWorkbenchWindow();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.run();
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.m_connectionDescriptors.clear();
            Iterator it = structuredSelection.iterator();
            while (it.hasNext()) {
                this.addConnectionDescriptor(it.next());
            }
        }
    }

    public void dispose() {
        this.m_connectionDescriptors.clear();
    }

    private void addConnectionDescriptor(Object object) {
        IConnectionDescriptor desc = this.adapterCast(object);
        if (desc != null) {
            this.m_connectionDescriptors.add(desc);
        }
    }

    private IConnectionDescriptor adapterCast(Object object) {
        if (object instanceof IConnectionDescriptor) {
            return (IConnectionDescriptor)object;
        }
        if (object instanceof IAdaptable) {
            return (IConnectionDescriptor)((IAdaptable)object).getAdapter(IConnectionDescriptor.class);
        }
        return null;
    }

    protected final IWorkbenchWindow getWorkbenchWindow() {
        return this.m_window;
    }

    protected final List<IConnectionDescriptor> getConnectionDescriptors() {
        return Collections.unmodifiableList(this.m_connectionDescriptors);
    }

    protected final ControlPanelView getControlPanelView() {
        try {
            return (ControlPanelView)this.getWorkbenchWindow().getActivePage().showView("com.jrockit.mc.flightrecorder.controlpanel.ui.views.ControlPanelView");
        }
        catch (PartInitException e) {
            DialogToolkit.showError((Shell)this.getWorkbenchWindow().getShell(), (String)Messages.FLIGHT_RECORDER_CONTROL_UNAVAILABLE_ERROR_TITLE, (String)Messages.FLIGHT_RECORDER_CONTROL_UNAVAILABLE_ERROR_MSG);
            return null;
        }
    }
}

