/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.actions;

import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.RecordingDescriptorHandler;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import java.util.logging.Level;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class CloseRecordingHandler
extends RecordingDescriptorHandler {
    public void handleRecordingDescriptor(IWorkbenchPart part, JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) {
        if (recordingDescriptor.getId() != 0L || this.okToCloseDefaultRecording(part.getSite().getShell(), recordingDescriptor)) {
            this.closeRecording(jvmModel, recordingDescriptor);
        }
    }

    private boolean okToCloseDefaultRecording(Shell parent, IRecordingDescriptor recordingDescriptor) {
        return MessageDialog.openQuestion((Shell)parent, (String)Messages.CLOSE_RECORDING_TITLE, (String)NLS.bind((String)Messages.CLOSE_RECORDING_MSG, (Object)recordingDescriptor.getName()));
    }

    private void closeRecording(JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) {
        try {
            Job.getJobManager().cancel((Object)recordingDescriptor);
            jvmModel.getFlightRecorderService().close(recordingDescriptor);
            jvmModel.update();
        }
        catch (FlightRecorderException e) {
            ControlPanel.getDefault().getLogger().log(Level.SEVERE, "Could not stop recording.");
        }
    }
}

