/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRecordingRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

class TemplateRepositoryFactory {
    private static final String USER_TEMPLATE_FILE = "recordingTemplates.xml";
    private static final String DEFAULT_TEMPLATE_FILE = "defaultTemplates.xml";

    TemplateRepositoryFactory() {
    }

    public static File getRecordingTemplateFile() {
        return new File(CorePlugin.getDefault().getWorkspaceDirectory(), USER_TEMPLATE_FILE);
    }

    public static TemplateRecordingRepository create() {
        TemplateRecordingRepository repository = TemplateRepositoryFactory.createFromSettings();
        if (repository == null) {
            repository = TemplateRepositoryFactory.loadDefaults();
        }
        return repository != null ? repository : new TemplateRecordingRepository();
    }

    private static TemplateRecordingRepository loadDefaults() {
        InputStream is = TemplateRepositoryFactory.class.getResourceAsStream(DEFAULT_TEMPLATE_FILE);
        if (is != null) {
            return TemplateRepositoryFactory.loadFromStreamAndClose(is);
        }
        return null;
    }

    private static TemplateRecordingRepository createFromSettings() {
        File templateFile = TemplateRepositoryFactory.getRecordingTemplateFile();
        if (templateFile.exists()) {
            try {
                return TemplateRepositoryFactory.loadFromStreamAndClose(new FileInputStream(templateFile));
            }
            catch (FileNotFoundException e) {
                ControlPanel.getDefault().getLogger().log(Level.SEVERE, "Error reading user defined template settings. Will try to use defaults.");
            }
        }
        return null;
    }

    private static TemplateRecordingRepository loadFromStreamAndClose(InputStream inputStream) {
        try {
            TemplateRecordingRepository templateRecordingRepository = (TemplateRecordingRepository)PersistenceToolkit.createObjectFromInputStream(TemplateRecordingRepository.class, (InputStream)inputStream);
            return templateRecordingRepository;
        }
        finally {
            TemplateRepositoryFactory.silentClose(inputStream);
        }
    }

    private static void silentClose(InputStream is) {
        try {
            is.close();
        }
        catch (IOException e) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not close stream properly when loading recording templates.");
        }
    }
}

