/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui;

import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingOption;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.rjmx.flr.EventTemplate;
import com.jrockit.mc.rjmx.flr.EventTypeMetadata;
import com.jrockit.mc.rjmx.flr.EventTypeSetting;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.flr.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportExportToolkit {
    public static final String JSF_FILE_EXTENSION = ".jsf";
    public static final String STRIPPED_RECORDING_TEMPLATE_FILE_EXTENSION = "jrt";
    public static final String RECORDING_TEMPLATE_FILE_EXTENSION = ".jrt";
    public static final String FLIGHT_RECORDING_FILE_EXTENSION = "jfr";
    public static final String RECORDING_TEMPLATE_FILE_VERSION = "1.0";
    private static final String RECORDING_TEMPLATE_FILE_VERSION_KEY = "__RECORDING_FILE_VERSION__";
    private static final String RECORDING_TEMPLATE_NAME_KEY = "__RECORDING_NAME__";
    private static final String RECORDING_TEMPLATE_DESCRIPTION_KEY = "__RECORDING_DESCRIPTION__";

    private ImportExportToolkit() {
        throw new Error("Don't");
    }

    public static void exportFile(RecordingTemplate template, File file) throws IOException {
        if (file.getName().endsWith(JSF_FILE_EXTENSION)) {
            ImportExportToolkit.exportToJsfFile(template, file);
        } else {
            ImportExportToolkit.exportToPropertiesFile(template, file);
        }
    }

    public static RecordingTemplate importFile(File file) throws IOException {
        if (file.getName().endsWith(JSF_FILE_EXTENSION)) {
            return ImportExportToolkit.importFromJsfFile(file);
        }
        if (file.getName().endsWith(RECORDING_TEMPLATE_FILE_EXTENSION)) {
            return ImportExportToolkit.importFromPropertiesFile(file);
        }
        RecordingTemplate template = ImportExportToolkit.importFromJsfFile(file);
        if (template == null) {
            template = ImportExportToolkit.importFromPropertiesFile(file);
        }
        return template;
    }

    private static RecordingTemplate importFromJsfFile(File file) {
        return null;
    }

    private static boolean exportToJsfFile(RecordingTemplate template, File file) {
        return false;
    }

    private static void exportToPropertiesFile(RecordingTemplate template, File file) throws IOException {
        ImportExportToolkit.internalExportToPropertiesFile(template, file);
    }

    private static void internalExportToPropertiesFile(RecordingTemplate template, File file) throws IOException {
        Properties properties = template.getProperties();
        properties.put(RECORDING_TEMPLATE_FILE_VERSION_KEY, RECORDING_TEMPLATE_FILE_VERSION);
        properties.put(RECORDING_TEMPLATE_NAME_KEY, template.getName());
        properties.put(RECORDING_TEMPLATE_DESCRIPTION_KEY, template.getDescription());
        FileOutputStream out = new FileOutputStream(file);
        try {
            String comment = "Flight Recording Template File (1.0)\n" + template.getName() + '\n' + template.getDescription();
            properties.store(out, comment);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    private static RecordingTemplate importFromPropertiesFile(File file) throws IOException {
        return ImportExportToolkit.interalImportPropertiesFile(file);
    }

    private static RecordingTemplate interalImportPropertiesFile(File file) throws IOException {
        RecordingTemplate template = new RecordingTemplate();
        template.setModifiable(true);
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream(file);
        try {
            properties.load(in);
            ImportExportToolkit.validate(properties);
            ImportExportToolkit.setName(template, properties);
            ImportExportToolkit.setDescription(template, properties);
            ImportExportToolkit.setOptions(template, properties);
            RecordingTemplate recordingTemplate = template;
            return recordingTemplate;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static void validate(Properties properties) throws IOException {
        String fileVersion = properties.getProperty(RECORDING_TEMPLATE_FILE_VERSION_KEY);
        if (fileVersion == null) {
            throw new IOException(Messages.IMPORT_EXPORT_TOOLKIT_UNSUPPORTED_TEMPLATE_FILE_ERROR_MSG);
        }
        if (Double.parseDouble(fileVersion) > Double.parseDouble(RECORDING_TEMPLATE_FILE_VERSION)) {
            throw new IOException(NLS.bind((String)Messages.IMPORT_EXPORT_TOOLKIT_WRONG_TEMPLATE_FILE_VERSION_ERROR_MSG, (Object)fileVersion, (Object)RECORDING_TEMPLATE_FILE_VERSION));
        }
        properties.remove(RECORDING_TEMPLATE_FILE_VERSION_KEY);
    }

    private static void setName(RecordingTemplate template, Properties properties) {
        String name = properties.getProperty(RECORDING_TEMPLATE_NAME_KEY);
        if (name != null) {
            template.setName(name);
            properties.remove(RECORDING_TEMPLATE_NAME_KEY);
        }
    }

    private static void setDescription(RecordingTemplate template, Properties properties) {
        String description = properties.getProperty(RECORDING_TEMPLATE_DESCRIPTION_KEY);
        if (description != null) {
            template.setDescription(description);
            properties.remove(RECORDING_TEMPLATE_DESCRIPTION_KEY);
        }
    }

    private static void setOptions(RecordingTemplate template, Properties properties) {
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            RecordingOption option = new RecordingOption();
            option.setFullKeyPath(key);
            option.setValue(properties.getProperty(key));
            template.setOption(option);
        }
    }

    public static Collection<RecordingTemplate> importServerTemplates(IFlightRecorderService service) throws FlightRecorderException {
        ArrayList<RecordingTemplate> templates = new ArrayList<RecordingTemplate>();
        EventTemplate[] eventTemplateArray = service.getServerTemplates();
        int n = eventTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventTemplate serverTemplate = eventTemplateArray[n2];
            templates.add(ImportExportToolkit.importServerTemplate(serverTemplate));
            ++n2;
        }
        return templates;
    }

    public static RecordingTemplate importServerTemplate(EventTemplate serverTemplate) {
        RecordingTemplate template = new RecordingTemplate();
        template.setModifiable(true);
        template.setName(serverTemplate.getName());
        template.setDescription(serverTemplate.getDescription());
        EventTypeSetting[] settings = serverTemplate.getSettings();
        ImportExportToolkit.addSettingsToTemplate(template, settings);
        return template;
    }

    public static void addSettingsToTemplate(RecordingTemplate template, EventTypeSetting[] settings) {
        EventTypeSetting[] eventTypeSettingArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            EventTypeSetting event = eventTypeSettingArray[n2];
            ImportExportToolkit.addProperties(template, event.getMetaData(), event.getConfigurableOptions());
            ++n2;
        }
    }

    private static void addProperties(RecordingTemplate rt, EventTypeMetadata eventMetadata, Option[] configurableProperties) {
        Option[] optionArray = configurableProperties;
        int n = configurableProperties.length;
        int n2 = 0;
        while (n2 < n) {
            Option property = optionArray[n2];
            RecordingOption ro = ImportExportToolkit.createRecordingOption(eventMetadata, property);
            rt.setOption(ro);
            ++n2;
        }
    }

    public static void removeSettingsFromTemplate(RecordingTemplate template, EventTypeSetting[] settings) {
        EventTypeSetting[] eventTypeSettingArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            EventTypeSetting event = eventTypeSettingArray[n2];
            ImportExportToolkit.removeProperties(template, event.getMetaData(), event.getConfigurableOptions());
            ++n2;
        }
    }

    private static void removeProperties(RecordingTemplate rt, EventTypeMetadata eventMetadata, Option[] configurableProperties) {
        Option[] optionArray = configurableProperties;
        int n = configurableProperties.length;
        int n2 = 0;
        while (n2 < n) {
            Option property = optionArray[n2];
            RecordingOption ro = ImportExportToolkit.createRecordingOption(eventMetadata, property);
            rt.removeOption(ro);
            ++n2;
        }
    }

    private static RecordingOption createRecordingOption(EventTypeMetadata eventMetadata, Option property) {
        RecordingOption ro = new RecordingOption();
        String eventPath = eventMetadata.getPath().replace('/', '.');
        String path = String.valueOf(eventPath) + '.' + property.getMetaData().getKey();
        ro.setFullKeyPath(path);
        ro.setValue(property.getValue().toString());
        return ro;
    }
}

