/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.core.MCAbstractUIPlugin;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ImageConstants;
import com.jrockit.mc.flightrecorder.controlpanel.ui.TemplateRepositoryFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRecordingRepository;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public final class ControlPanel
extends MCAbstractUIPlugin {
    private static final String PLUGIN_ID = "com.jrockit.mc.flightrecorder.controlpanel.ui";
    private static ControlPanel s_plugin;
    private TemplateRecordingRepository m_repository;
    private JvmRepository m_jvmRepository = new JvmRepository();

    public ControlPanel() {
        super(PLUGIN_ID);
    }

    public JvmRepository getJvmRepository() {
        return this.m_jvmRepository;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.m_repository = TemplateRepositoryFactory.create();
        s_plugin = this;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerFromImageConstantClass(registry, ImageConstants.class);
    }

    private void saveRecordingTemplates() {
        File file = TemplateRepositoryFactory.getRecordingTemplateFile();
        try {
            if (file.exists()) {
                this.exportRepositoryByBackup(file);
            } else {
                PersistenceToolkit.exportObjectToFile((Object)this.m_repository, (File)file);
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, NLS.bind((String)"Could not save recording templates file at {0}.", (Object)file), e);
        }
    }

    private void exportRepositoryByBackup(File file) throws IOException {
        File tempFile = File.createTempFile(String.valueOf(file.getName()) + '.', ".temp", file.getParentFile());
        PersistenceToolkit.exportObjectToFile((Object)this.m_repository, (File)tempFile);
        File backupFile = new File(file.getParent(), String.valueOf(file.getName()) + ".bak");
        while (!file.renameTo(backupFile)) {
            backupFile = new File(backupFile.getParent(), String.valueOf(backupFile.getName()) + ".bak");
        }
        if (!tempFile.renameTo(file)) {
            throw new IOException(NLS.bind((String)"Unable to rename new file from {0} to {1}.", (Object)file, (Object)backupFile));
        }
        if (!backupFile.delete()) {
            throw new IOException(NLS.bind((String)"Unable to remove old file {0}.", (Object)backupFile));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.m_jvmRepository.clear();
        this.saveRecordingTemplates();
        s_plugin = null;
        super.stop(context);
    }

    public static ControlPanel getDefault() {
        return s_plugin;
    }

    public TemplateRecordingRepository getTemplateRecordingRepository() {
        return this.m_repository;
    }
}

