/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.diagnostic.sections;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticCommand;
import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticCommands;
import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticModel;
import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticParameter;
import com.jrockit.mc.console.ui.diagnostic.providers.DiagnosticCommandLabelProvider;
import com.jrockit.mc.console.ui.diagnostic.sections.Messages;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import com.jrockit.mc.core.sections.MCClientSectionPart;
import com.jrockit.mc.core.sections.MCSectionPart;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ParameterSectionPart
extends MCClientSectionPart
implements IPartSelectionListener {
    private final DiagnosticModel m_diagnosticModel;
    private Button m_executeButton;
    private Composite m_contentHolder;
    private Button m_resetButton;
    private Control[] m_parameterControls;

    public ParameterSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier, DiagnosticModel model) {
        super(parent, toolkit, MCSectionPart.getAccessibilityDescriptionStyle(), sectionIdentifier);
        this.m_diagnosticModel = model;
    }

    protected void initializeSection(Section section) {
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        Composite client = this.getFormToolkit().createComposite(section, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 7;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        this.m_contentHolder = this.createInitialialContent(client);
        this.updateContentHolderLayout();
        return client;
    }

    private void updateContentHolderLayout() {
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 50;
        gd.heightHint = 50;
        this.m_contentHolder.setLayoutData((Object)gd);
        this.getSection().layout(true, true);
    }

    public Composite createInitialialContent(Composite parent) {
        ScrolledForm container = this.getFormToolkit().createScrolledForm(parent);
        this.getFormToolkit().paintBordersFor((Composite)container);
        container.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        Label label = this.getFormToolkit().createLabel(container.getBody(), Messages.ParameterSectionPart_LABEL_NO_DIAGNOSTIC_COMMANDS_FOUND_TEXT);
        label.setLayoutData((Object)new TableWrapData());
        container.getBody().setLayout((Layout)new TableWrapLayout());
        return container;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (!selection.isEmpty()) {
            String commandName = (String)((IStructuredSelection)selection).getFirstElement();
            DiagnosticCommand command = this.m_diagnosticModel.getCommand(commandName);
            this.updateSection(command);
        }
    }

    private void updateSection(DiagnosticCommand command) {
        if (this.m_contentHolder != null && !this.m_contentHolder.isDisposed()) {
            this.m_contentHolder.dispose();
        }
        this.m_contentHolder = this.createParameterWidgetHolder((Composite)this.getSection().getClient(), command, 2);
        this.updateContentHolderLayout();
    }

    private Composite createParameterWidgetHolder(Composite parent, DiagnosticCommand command, int span) {
        ScrolledForm sform = this.getFormToolkit().createScrolledForm(parent);
        sform.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        sform.getBody().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        sform.getBody().setLayout((Layout)layout);
        this.createParameterWidgets(sform.getBody(), command, layout.numColumns);
        return sform;
    }

    public static String getSeverityClassText(String commandName) {
        int severity = DiagnosticCommands.getSeverity(commandName);
        switch (severity) {
            case 1: {
                return Messages.ParameterSectionPart_NORMAL_DIAGNOSTIC_COMMAND_DESCRIPTION;
            }
            case 3: {
                return Messages.ParameterSectionPart_ADVANCED_DIAGNOSTIC_COMMAND_DESCRIPTION;
            }
            case 5: {
                return Messages.ParameterSectionPart_INTERNAL_DIAGNOSTIC_COMMAND_DESCRIPTION;
            }
        }
        return Messages.ParameterSectionPart_UNKNOWN_DIAGNOSTIC_COMMAND_DESCRIPTION;
    }

    private void updateSectionText(DiagnosticCommand command) {
        this.getSection().setText(MessageFormat.format(Messages.ParameterSectionPart_COMMAND_TITLE_X, command.getName()));
        if (CorePlugin.getDefault().getAccessibilityMode()) {
            this.getSection().setDescription(this.getSection().getText());
        }
    }

    private void createParameterWidgets(Composite parent, DiagnosticCommand command, int span) {
        this.updateSectionText(command);
        TableWrapData descriptionData = new TableWrapData(256, 32);
        descriptionData.colspan = 1;
        descriptionData.indent = 5;
        Label descriptionLabel = this.createDescriptionLabel(parent, command);
        descriptionLabel.setLayoutData((Object)descriptionData);
        TableWrapData executeData = new TableWrapData(256, 32);
        executeData.align = 8;
        this.m_executeButton = this.createExecuteButton(parent, command);
        this.m_executeButton.setLayoutData((Object)executeData);
        this.createRowSeparator(parent);
        DiagnosticParameter[] params = command.getParameters();
        this.m_parameterControls = new Control[params.length];
        int n = 0;
        while (n < params.length) {
            this.createParameterRow(parent, command, params[n], n);
            this.createRowSeparator(parent);
            ++n;
        }
        if (params.length == 0) {
            TableWrapData gd1 = new TableWrapData(256, 256);
            gd1.colspan = 2;
            gd1.valign = 16;
            Label label = this.getFormToolkit().createLabel(parent, Messages.ParameterSectionPart_LABEL_NO_PARAMETERS_TEXT);
            label.setLayoutData((Object)gd1);
        } else {
            TableWrapData resetData = new TableWrapData(8, 32, 1, 2);
            this.m_resetButton = this.createResetButton(parent, command);
            this.m_resetButton.setLayoutData((Object)resetData);
        }
    }

    private void createParameterRow(Composite parent, DiagnosticCommand command, DiagnosticParameter param, int n) {
        Control parameterInput;
        TableWrapData parameterLabelData = new TableWrapData(256, 32);
        parameterLabelData.indent = 5;
        Label parameterLabel = this.createParameterLabel(parent, param);
        parameterLabel.setLayoutData((Object)parameterLabelData);
        TableWrapData parameterInputData = new TableWrapData(128, 32);
        this.m_parameterControls[n] = parameterInput = this.createParameterInput(parent, command, param);
        if (parameterInput instanceof Button) {
            parameterInputData.align = 4;
        }
        parameterInput.setLayoutData((Object)parameterInputData);
    }

    private Label createDescriptionLabel(Composite parent, DiagnosticCommand command) {
        Label descriptionLabel = this.getFormToolkit().createLabel(parent, ParameterSectionPart.truncateDescription(command.getDescription()), 64);
        descriptionLabel.setFont(CorePlugin.getDefault().getFontColorToolkit().getStandardBoldFont());
        return descriptionLabel;
    }

    private void createRowSeparator(Composite parent) {
        Label separator = this.getFormToolkit().createLabel(parent, "", 258);
        TableWrapData tableData = new TableWrapData(128, 16);
        tableData.grabHorizontal = true;
        tableData.colspan = 2;
        separator.setLayoutData((Object)tableData);
    }

    private Button getExecuteButton() {
        return this.m_executeButton;
    }

    private Control createParameterInput(Composite composite, DiagnosticCommand command, DiagnosticParameter pp) {
        if (pp.isBoolean()) {
            return this.createParameterCheckbox(composite, command, pp);
        }
        return this.createParameterText(composite, command, pp);
    }

    private Control createParameterCheckbox(Composite composite, DiagnosticCommand command, DiagnosticParameter pp) {
        Button button = this.getFormToolkit().createButton(composite, new String(), 131104);
        button.setSelection(Boolean.TRUE.toString().equalsIgnoreCase(pp.getValue()));
        button.addSelectionListener((SelectionListener)new CheckParameterModifier(command, pp));
        return button;
    }

    private Control createParameterText(Composite composite, DiagnosticCommand command, DiagnosticParameter pp) {
        Text text = this.getFormToolkit().createText(composite, pp.getValue(), 2);
        text.setToolTipText(pp.getDescription());
        class ReplaceContentAdapter
        extends TextContentAdapter {
            ReplaceContentAdapter() {
            }

            public void insertControlContents(Control control, String text, int cursorPosition) {
                ((Text)control).setText(text);
                if (text != null && text.length() > 0) {
                    ((Text)control).setSelection(text.length());
                }
            }
        }
        class ParameterContentProposalProvider
        extends SimpleContentProposalProvider {
            private final DiagnosticParameter m_param;

            ParameterContentProposalProvider(DiagnosticParameter param) {
                super(param.getContentAssist());
                this.m_param = param;
            }

            public IContentProposal[] getProposals(String contents, int position) {
                this.setProposals(this.m_param.getContentAssist());
                return super.getProposals(contents, position);
            }
        }
        new ContentProposalAdapter((Control)text, (IControlContentAdapter)new ReplaceContentAdapter(), (IContentProposalProvider)new ParameterContentProposalProvider(pp), null, null);
        text.addModifyListener((ModifyListener)new TextParameterModifier(command, pp));
        this.hookTabListener(text);
        return text;
    }

    private void hookTabListener(Text text) {
        text.addTraverseListener((TraverseListener)new SimpleTraverseListener(true));
    }

    private Label createParameterLabel(Composite parent, DiagnosticParameter pp) {
        return this.getFormToolkit().createLabel(parent, ParameterSectionPart.removeLineBreaks(pp.getShortDescription()), 64);
    }

    private Button createExecuteButton(Composite container, final DiagnosticCommand command) {
        Button button = this.getFormToolkit().createButton(container, Messages.ParameterSectionPart_EXECUTE_BUTTON_TEXT, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParameterSectionPart.this.checkIfOkToExecuteWithSeverity(command.getSeverity())) {
                    ParameterSectionPart.this.m_diagnosticModel.execute(command);
                }
            }
        });
        button.setImage(DiagnosticCommandLabelProvider.getSeverityClassImage(command.getName()));
        button.setToolTipText(ParameterSectionPart.getSeverityClassText(command.getName()));
        button.setEnabled(command.isExecutable());
        return button;
    }

    private boolean testSeverityAgainstConsolePreferenceStore(String title, String severityDescription, String toggleMessage, String property) {
        IPreferenceStore consolePreferenceStore = ConsolePlugin.getDefault().getPreferenceStore();
        if (!consolePreferenceStore.getBoolean(property)) {
            String message = NLS.bind((String)Messages.ParameterSectionPart_DIALOG_ASK_TO_RUN_DIAGNOSTIC_COMMAND_MESSAGE_TEXT, (Object)severityDescription);
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)CorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (String)toggleMessage, (boolean)consolePreferenceStore.getBoolean(property), null, null);
            if (dialog.getReturnCode() == 2) {
                consolePreferenceStore.setValue(property, dialog.getToggleState());
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean checkIfOkToExecuteWithSeverity(int severity) {
        if (severity == 999) {
            return this.testSeverityAgainstConsolePreferenceStore(Messages.ParameterSectionPart_DIALOG_RUN_UNKNOWN_DIAGNOSTIC_COMMAND_TITLE, Messages.ParameterSectionPart_UNKNOWN_DIAGNOSTIC_COMMAND_DESCRIPTION, com.jrockit.mc.console.ui.preferences.Messages.DiagnosticPage_LABEL_EXECUTE_UNKNOWN_DIAGNOSTIC_COMMANDS_LABEL, "console.ui.diagnostic.runUnknownWithoutWarning");
        }
        if (severity == 5) {
            return this.testSeverityAgainstConsolePreferenceStore(Messages.ParameterSectionPart_DIALOG_RUN_INTERNAL_DIAGNOSTIC_COMMAND_TITLE, Messages.ParameterSectionPart_INTERNAL_DIAGNOSTIC_COMMAND_DESCRIPTION, com.jrockit.mc.console.ui.preferences.Messages.DiagnosticPage_LABEL_EXECUTE_INTERNAL_DIAGNOSTIC_COMMANDS_LABEL, "console.ui.diagnostic.runInternalWithoutWarning");
        }
        if (severity == 3) {
            return this.testSeverityAgainstConsolePreferenceStore(Messages.ParameterSectionPart_DIALOG_RUN_ADVANCED_DIAGNOSTIC_COMMAND_TITLE, Messages.ParameterSectionPart_ADVANCED_DIAGNOSTIC_COMMAND_DESCRIPTION, com.jrockit.mc.console.ui.preferences.Messages.DiagnosticPage_LABEL_EXECUTE_ADVANCED_DIAGNOSTIC_COMMANDS_LABEL, "console.ui.diagnostic.runAdvancedWithoutWarning");
        }
        return true;
    }

    private Button createResetButton(Composite parent, final DiagnosticCommand command) {
        final Button resetButton = this.getFormToolkit().createButton(parent, Messages.ParameterSectionPart_BUTTON_RESET_TEXT, 0);
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagnosticParameter[] parameters = command.getParameters();
                int i = 0;
                while (i < parameters.length) {
                    DiagnosticParameter parameter = parameters[i];
                    if (!parameter.getValue().equals(parameter.getDefaultServerValue())) {
                        parameter.setValue(parameter.getDefaultServerValue());
                        Control control = ParameterSectionPart.this.m_parameterControls[i];
                        if (control instanceof Button) {
                            ((Button)control).setSelection(Boolean.TRUE.toString().equalsIgnoreCase(parameter.getValue()));
                        } else {
                            ((Text)control).setText(parameter.getValue());
                        }
                    }
                    ++i;
                }
                resetButton.setEnabled(!command.hasDefaultServerParemeterValues());
            }
        });
        resetButton.setEnabled(!command.hasDefaultServerParemeterValues());
        return resetButton;
    }

    private Button getResetButton() {
        return this.m_resetButton;
    }

    private static String removeLineBreaks(String s) {
        return s.replaceAll("\n", " ");
    }

    private static String truncateDescription(String description) {
        if (description.length() > 100) {
            int index = description.indexOf(".");
            if (index != -1) {
                return description.substring(0, index + 1);
            }
            index = description.indexOf("\n");
            if (index != -1) {
                return description.substring(0, index);
            }
        }
        return description;
    }

    public class CheckParameterModifier
    extends SelectionAdapter {
        private final DiagnosticParameter m_parameter;
        private final DiagnosticCommand m_command;

        public CheckParameterModifier(DiagnosticCommand command, DiagnosticParameter param) {
            this.m_parameter = param;
            this.m_command = command;
        }

        public void widgetSelected(SelectionEvent e) {
            Button checkButton = (Button)e.widget;
            this.m_parameter.setValue(checkButton.getSelection() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            ParameterSectionPart.this.getExecuteButton().setEnabled(this.m_command.isExecutable());
            ParameterSectionPart.this.getResetButton().setEnabled(!this.m_command.hasDefaultServerParemeterValues());
        }
    }

    public class TextParameterModifier
    implements ModifyListener {
        private final DiagnosticParameter m_parameter;
        private final DiagnosticCommand m_command;

        public TextParameterModifier(DiagnosticCommand command, DiagnosticParameter param) {
            this.m_parameter = param;
            this.m_command = command;
        }

        public void modifyText(ModifyEvent e) {
            String s = ((Text)e.widget).getText();
            if (!s.equals(this.m_parameter.getValue())) {
                this.m_parameter.setValue(s);
                ParameterSectionPart.this.getExecuteButton().setEnabled(this.m_command.isExecutable());
                ParameterSectionPart.this.getResetButton().setEnabled(!this.m_command.hasDefaultServerParemeterValues());
            }
        }
    }
}

