/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.diagnostic.sections;

import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticModel;
import com.jrockit.mc.console.ui.diagnostic.sections.AppendAction;
import com.jrockit.mc.console.ui.diagnostic.sections.ClearAction;
import com.jrockit.mc.console.ui.diagnostic.sections.Messages;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.sections.MCSectionPart;
import com.jrockit.mc.core.sections.TextSectionPart;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class LogSectionPart
extends TextSectionPart
implements Observer {
    private final DiagnosticModel m_model;
    private Font m_font;

    public LogSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier, DiagnosticModel model) {
        super(parent, toolkit, MCSectionPart.getAccessibilityDescriptionStyle(), 50, sectionIdentifier);
        this.m_model = model;
        this.m_model.addObserver(this);
    }

    public void initializeSection(Section section) {
        section.setText(Messages.LogSectionPart_DIAGNOSTIC_COMMAND_OUTPUT_TITLE);
        if (CorePlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    public void initializeText(Text text) {
        this.m_font = new Font((Device)text.getDisplay(), "Courier", 8, 0);
        text.setFont(this.m_font);
        text.setText("");
    }

    protected ScrolledForm createScrolledForm(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        this.initializeToolbar();
        ScrolledForm form = toolkit.createScrolledForm(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        GridData wrapData = new GridData(4, 4, true, true);
        this.createText(toolkit, form.getBody());
        this.initializeText(this.getText());
        this.getText().setLayoutData((Object)wrapData);
        form.getBody().setLayout((Layout)layout);
        return form;
    }

    private void initializeToolbar() {
        this.getMCToolBarManager().add((IAction)new ClearAction(this.m_model));
        this.getMCToolBarManager().add((IAction)new AppendAction(this.m_model));
    }

    public void dispose() {
        if (this.m_font != null && !this.m_font.isDisposed()) {
            this.m_font.dispose();
        }
    }

    public void update(Observable o, Object arg) {
        this.setText(this.m_model.getLogText());
    }
}

