/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.diagnostic.sections;

import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticModel;
import com.jrockit.mc.console.ui.diagnostic.providers.DiagnosticCommandLabelProvider;
import com.jrockit.mc.console.ui.diagnostic.providers.DiagnosticCommandProvider;
import com.jrockit.mc.console.ui.diagnostic.sections.Messages;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.sections.FieldTableViewerSectionPart;
import com.jrockit.mc.core.sections.MCSectionPart;
import com.jrockit.mc.core.ui.fields.FieldLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CommandSectionPart
extends FieldTableViewerSectionPart {
    private static final Field[] FIELD_PROTOTYPES = new Field[]{DiagnosticCommandProvider.FIELD_COMMAND};
    private final DiagnosticModel m_diagnosticModel;

    public CommandSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier, IDialogSettings settings, DiagnosticModel model) {
        super(parent, toolkit, MCSectionPart.getAccessibilityDescriptionStyle(), sectionIdentifier, FIELD_PROTOTYPES, settings);
        this.m_diagnosticModel = model;
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.CommandSectionPart_AVAILABLE_DIAGNOSTIC_COMMANDS);
        if (CorePlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    protected void initializePart() {
        super.initializePart();
        this.getTableViewer().setContentProvider((IContentProvider)new DiagnosticCommandProvider());
        this.getTableViewer().setInput((Object)this.m_diagnosticModel.getCommandNames());
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new FieldLabelProvider(this.getFields(), (IBaseLabelProvider)new DiagnosticCommandLabelProvider()));
        this.getTableViewer().setSelection(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return "print_threads".equals(element);
            }
        }, true);
        this.setSortColumn(DiagnosticCommandProvider.FIELD_COMMAND, false);
    }
}

