/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.diagnostic.model;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.misc.CompositeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.management.openmbean.CompositeData;
import org.w3c.dom.Element;

public class DiagnosticParameter
extends CompositeSupport
implements XmlEnabled {
    static final String TAG_DIAGNOSTIC_PARAMETER = "DiagnosticParameter";
    static final String XML_ATTRIBUTE_NAME = "parameterName";
    private static final String XML_ATTRIBUTE_VALUE = "parameterValue";
    private static final String XML_ATTRIBUTE_LAST_VALID_VALUE = "parameterLastValidValue";
    private final String OPEN_NAME_COMMAND = "command";
    private final String OPEN_NAME_NAME = "name";
    private final String OPEN_NAME_DESCRIPTION = "description";
    private final String OPEN_NAME_ISREQUIRED = "isRequired";
    private final String OPEN_NAME_TYPE = "type";
    private final String OPEN_NAME_DEFAULTVALUE = "defaultValue";
    private String[] m_contentAssist = new String[0];
    private String m_value = new String();
    private String m_lastValue;

    public DiagnosticParameter(CompositeData compositeData) {
        super(compositeData);
        this.setValidValue(this.getDefaultValue());
        this.m_value = this.getDefaultValue();
    }

    public String getName() {
        return this.getString("name");
    }

    public String getCommand() {
        return this.getString("command");
    }

    public String getDescription() {
        return this.getString("description");
    }

    public String getShortDescription() {
        int index;
        String longDescription = this.getDescription();
        if (longDescription != null && (index = longDescription.indexOf(41)) != -1 && index < longDescription.length() - 1) {
            return DiagnosticParameter.makeFirstLetterUppercase(longDescription.substring(index + 1).trim());
        }
        return longDescription;
    }

    private static String makeFirstLetterUppercase(String trim) {
        if (trim.length() > 0) {
            return String.valueOf(Character.toString(trim.charAt(0)).toUpperCase()) + trim.substring(1);
        }
        return trim;
    }

    public String getType() {
        return this.getString("type");
    }

    public String getDefaultValue() {
        if (this.m_contentAssist.length > 0) {
            return this.m_contentAssist[this.m_contentAssist.length - 1];
        }
        return this.getDefaultServerValue();
    }

    public String getDefaultServerValue() {
        String def = this.getString("defaultValue");
        return "null".equals(def) ? "" : def;
    }

    public boolean isBoolean() {
        return Boolean.TRUE.toString().equalsIgnoreCase(this.getDefaultValue()) || Boolean.FALSE.toString().equalsIgnoreCase(this.getDefaultValue());
    }

    public boolean isRequired() {
        return this.getBoolean("isRequired");
    }

    public void setValidValue(String value) {
        if (value != null && value.length() != 0) {
            this.m_lastValue = value;
            ArrayList<String> list = new ArrayList<String>();
            list.addAll((Collection)Arrays.asList(this.m_contentAssist));
            if (!list.contains(value)) {
                list.add(value);
            }
            if (list.size() > 7) {
                list.remove(0);
            }
            this.m_contentAssist = list.toArray(new String[0]);
        }
    }

    public String getLastValidValue() {
        return this.m_lastValue;
    }

    public void setContentAssist(String[] ca) {
        this.m_contentAssist = ca;
    }

    public String[] getContentAssist() {
        return this.m_contentAssist;
    }

    public void setValue(String text) {
        this.m_value = text;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean hasDefaultServerValue() {
        return this.getValue().equals(this.getDefaultServerValue());
    }

    public void exportToXml(Element parentNode) {
        String defaultServerValue = this.getDefaultServerValue();
        if (defaultServerValue.equals(this.getValue()) && defaultServerValue.equals(this.getLastValidValue())) {
            return;
        }
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        XmlToolkit.setSetting((Element)e, (String)XML_ATTRIBUTE_NAME, (String)this.getName());
        XmlToolkit.setSetting((Element)e, (String)XML_ATTRIBUTE_VALUE, (String)this.getValue());
        XmlToolkit.setSetting((Element)e, (String)XML_ATTRIBUTE_LAST_VALID_VALUE, (String)this.getLastValidValue());
    }

    public String getComponentTag() {
        return TAG_DIAGNOSTIC_PARAMETER;
    }

    public void initializeFromXml(Element node) throws Exception {
        this.setValue(XmlToolkit.getSetting((Element)node, (String)XML_ATTRIBUTE_VALUE, null));
        this.setValidValue(XmlToolkit.getSetting((Element)node, (String)XML_ATTRIBUTE_LAST_VALID_VALUE, null));
    }
}

