/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.diagnostic.model;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticCommand;
import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticCommands;
import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticParameter;
import com.jrockit.mc.console.ui.diagnostic.model.Messages;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiagnosticModel
extends Observable
implements XmlEnabled {
    public static final String TAG_DIAGNOSTIC_MODEL = "DiagnosticModel";
    private final DiagnosticCommands m_diagnosticCommandProvider;
    private final IDialogSettings m_dialogSettings;
    private final Map<String, DiagnosticCommand> m_commandMap = new HashMap<String, DiagnosticCommand>();
    private String m_logBuffer = "";
    private boolean m_appendToLog = false;

    public DiagnosticModel(DiagnosticCommands diagnosticBean, IDialogSettings settings) {
        this.m_diagnosticCommandProvider = diagnosticBean;
        this.m_dialogSettings = settings;
    }

    public synchronized DiagnosticCommand getCommand(String commandName) {
        DiagnosticCommand dc = this.m_commandMap.get(commandName);
        if (dc == null) {
            DiagnosticParameter[] params = this.getDiagnosticCommandProvider().getParameters(commandName);
            int n = 0;
            while (n < params.length) {
                String[] ca = this.m_dialogSettings.getArray(this.getContentAssistSettingsKey(params[n]));
                if (ca != null) {
                    params[n].setContentAssist(ca);
                }
                ++n;
            }
            String help = this.getDiagnosticCommandProvider().getHelp(commandName);
            String description = this.getDiagnosticCommandProvider().getDescription(commandName);
            int severity = DiagnosticCommands.getSeverity(commandName);
            dc = new DiagnosticCommand(commandName, params, description, severity, help);
            this.m_commandMap.put(commandName, dc);
        }
        return dc;
    }

    public DiagnosticCommands getDiagnosticCommandProvider() {
        return this.m_diagnosticCommandProvider;
    }

    public void setAppend(boolean append) {
        this.m_appendToLog = append;
    }

    public boolean getAppend() {
        return this.m_appendToLog;
    }

    public void clear() {
        this.m_logBuffer = "";
        this.setChanged();
    }

    public void writeToLogBuffer(String text) {
        if (!this.m_appendToLog) {
            this.clear();
        }
        this.m_logBuffer = String.valueOf(this.m_logBuffer) + text;
        this.setChanged();
    }

    public String getLogText() {
        return this.m_logBuffer;
    }

    public void execute(DiagnosticCommand command) {
        try {
            String result = this.getDiagnosticCommandProvider().executeCommand(command);
            if ("".equals(result)) {
                result = MessageFormat.format(Messages.DiagnosticModel_COMMAND_X_EXECUTED_TEXT, command.getName());
            }
            this.writeToLogBuffer(result);
            DiagnosticParameter[] ps = command.getParameters();
            int n = 0;
            while (n < ps.length) {
                ps[n].setValidValue(ps[n].getValue());
                ++n;
            }
            this.storeParametersSettings(command);
            this.notifyObservers();
        }
        catch (Exception exception) {
            this.writeToLogBuffer(MessageFormat.format(Messages.DiagnosticModel_ERROR_MESSAGE_X_LOG_TEXT, exception.getMessage()));
        }
    }

    public String[] getCommandNames() {
        return this.getDiagnosticCommandProvider().getCommandNames();
    }

    private String getContentAssistSettingsKey(DiagnosticParameter param) {
        return "console.diagnostics" + param.getCommand() + "." + param.getName() + ".content.assist";
    }

    private void storeParametersSettings(DiagnosticCommand command) {
        DiagnosticParameter[] params = command.getParameters();
        int n = 0;
        while (n < params.length) {
            this.m_dialogSettings.put(this.getContentAssistSettingsKey(params[n]), params[n].getContentAssist());
            ++n;
        }
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        for (DiagnosticCommand command : this.m_commandMap.values()) {
            command.exportToXml(e);
        }
    }

    public String getComponentTag() {
        return TAG_DIAGNOSTIC_MODEL;
    }

    public void initializeFromXml(Element node) throws Exception {
        List list = XmlToolkit.getChildNodesByTag((Node)node, (String)"DiagnosticCommand");
        if (list != null) {
            for (Element commandNode : list) {
                String name = XmlToolkit.getSetting((Element)commandNode, (String)"commandName", (String)"");
                DiagnosticCommand command = this.getCommand(name);
                command.initializeFromXml(commandNode);
            }
        }
    }
}

