/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.diagnostic.model;

import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticCommand;
import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticParameter;
import com.jrockit.mc.console.ui.diagnostic.model.Messages;
import com.jrockit.mc.rjmx.core.IMBeanService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticCommands {
    private final ObjectName DIAGNOSTIC_BEAN;
    private static final String DIAGNOSTIC_BEAN_OBJECT_NAME_R27 = "bea.jrockit.management:type=DiagnosticCommand";
    private static final String DIAGNOSTIC_BEAN_OBJECT_NAME_R28 = "oracle.jrockit.management:type=DiagnosticCommand";
    private final String OPERATION_ALL_COMMANDS = "AllCommands";
    private final String OPERATION_GET_HELP = "getHelp";
    private final String OPERATION_GET_PARAMETERS = "getParameters";
    private final String OPERATION_GET_DESCRIPTION = "getHelp";
    private final String OPERATION_EXCEUTE = "execute";
    private final IMBeanService m_mbeanService;
    private final Logger m_logger;
    private static boolean m_severityLoaded;
    private static Properties m_severityProperties;
    public static final String DIAGNOSTIC_COMMAND_PRINT_THREDS = "print_threads";
    public static final int DIAGNOSTIC_COMMAND_SEVERITY_UNKNOWN = 999;
    public static final int DIAGNOSTIC_COMMAND_SEVERITY_NORMAL = 1;
    public static final int DIAGNOSTIC_COMMAND_SEVERITY_ADVANCED = 3;
    public static final int DIAGNOSTIC_COMMAND_SEVERITY_JROCKIT_INTERNAL = 5;

    private static synchronized void ensureSeverityIsInitialized() {
        if (!m_severityLoaded) {
            Properties properties = new Properties();
            ClassLoader loader = DiagnosticCommands.class.getClassLoader();
            InputStream in = loader.getResourceAsStream("com/jrockit/mc/console/ui/diagnostic/model/severity.properties");
            try {
                properties.load(in);
                m_severityProperties = properties;
                m_severityLoaded = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public DiagnosticCommands(IMBeanService mbeanService, Logger logger) {
        this.m_mbeanService = mbeanService;
        this.m_logger = logger;
        String name = null;
        ObjectName temp = null;
        try {
            name = mbeanService.getProxyNames().getClass().getName().endsWith("JMXR27Names") ? DIAGNOSTIC_BEAN_OBJECT_NAME_R27 : DIAGNOSTIC_BEAN_OBJECT_NAME_R28;
            temp = new ObjectName(name);
        }
        catch (Exception e) {
            this.m_logger.log(Level.SEVERE, "Could not construct object name for diagnostic command", e);
        }
        this.DIAGNOSTIC_BEAN = temp;
        m_severityLoaded = false;
        m_severityProperties = new Properties();
    }

    public String[] getCommandNames() {
        try {
            Object result1 = this.m_mbeanService.getMBeanServerConnection().getAttribute(this.DIAGNOSTIC_BEAN, "AllCommands");
            if (result1 instanceof Collection) {
                return ((Collection)result1).toArray(new String[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[0];
    }

    public String getHelp(String name) {
        try {
            Object[] paramValues = new Object[]{name};
            String[] signature = new String[]{String.class.getName()};
            Object object = this.m_mbeanService.getMBeanServerConnection().invoke(this.DIAGNOSTIC_BEAN, "getHelp", paramValues, signature);
            if (object instanceof String) {
                return (String)object;
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, "Could not get Help for diagnostic command " + name, e);
        }
        return Messages.DiagnosticCommands_NO_HELP_AVAILABLE_TEXT;
    }

    public DiagnosticParameter[] getParameters(String name) {
        try {
            Object object = this.m_mbeanService.getMBeanServerConnection().invoke(this.DIAGNOSTIC_BEAN, "getParameters", new Object[]{name}, new String[]{String.class.getName()});
            if (object instanceof Collection) {
                return this.createDiagnosticParameters(((Collection)object).toArray(new CompositeData[0]));
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, "Could not get parameters for diagnostic command " + name, e);
        }
        return new DiagnosticParameter[0];
    }

    private DiagnosticParameter[] createDiagnosticParameters(CompositeData[] cds) {
        DiagnosticParameter[] diagnosticParameter = new DiagnosticParameter[cds.length];
        int n = 0;
        while (n < diagnosticParameter.length) {
            diagnosticParameter[n] = new DiagnosticParameter(cds[n]);
            ++n;
        }
        return diagnosticParameter;
    }

    public String getDescription(String name) {
        try {
            Object object = this.m_mbeanService.getMBeanServerConnection().invoke(this.DIAGNOSTIC_BEAN, "getHelp", new Object[]{name}, new String[]{String.class.getName()});
            if (object instanceof String) {
                return (String)object;
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, "Could not get decription for diagnostic command " + name, e);
        }
        return Messages.DiagnosticCommands_NO_DESCRIPTION_AVAILABLE_TEXT;
    }

    public static int getSeverity(String name) {
        String value;
        if (!m_severityLoaded) {
            DiagnosticCommands.ensureSeverityIsInitialized();
        }
        if ((value = m_severityProperties.getProperty(name)) != null) {
            try {
                int severity = Integer.parseInt(value);
                if (severity == 1 || severity == 3 || severity == 5) {
                    return severity;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 999;
    }

    public String executeCommand(DiagnosticCommand command) throws Exception {
        DiagnosticParameter[] diagParams = command.getParameters();
        String[] signature = new String[]{String.class.getName(), Map.class.getName()};
        Object[] params = new Object[]{command.getName(), this.createParameterMap(diagParams)};
        Object object = this.m_mbeanService.getMBeanServerConnection().invoke(this.DIAGNOSTIC_BEAN, "execute", params, signature);
        if (object instanceof String) {
            return (String)object;
        }
        throw new Exception(Messages.DiagnosticCommands_NOT_A_STRING_RESULT_RETURNED);
    }

    private Map<String, String> createParameterMap(DiagnosticParameter[] parameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        int n = 0;
        while (n < parameters.length) {
            String value = parameters[n].getValue();
            if (value != null && !"".equals(value.trim())) {
                map.put(parameters[n].getName(), parameters[n].getValue());
            }
            ++n;
        }
        return map;
    }
}

