/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.diagnostic.model;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticParameter;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiagnosticCommand
implements XmlEnabled {
    static final String TAG_DIAGNOSTIC_COMMAND = "DiagnosticCommand";
    static final String XML_ATTRIBUTE_NAME = "commandName";
    private final DiagnosticParameter[] m_parameters;
    private final String m_descriptionText;
    private final int m_severity;
    private final String m_helpText;
    private final String m_name;

    public DiagnosticCommand(String name, DiagnosticParameter[] parameters, String descriptiontext, int severity, String helpText) {
        this.m_name = name;
        this.m_parameters = parameters;
        this.m_descriptionText = descriptiontext;
        this.m_severity = severity;
        this.m_helpText = helpText;
    }

    public String getDescription() {
        return this.m_descriptionText;
    }

    public DiagnosticParameter[] getParameters() {
        return this.m_parameters;
    }

    public int getSeverity() {
        return this.m_severity;
    }

    public String getHelp() {
        return this.m_helpText;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isExecutable() {
        int n = 0;
        while (n < this.m_parameters.length) {
            if (this.m_parameters[n].isRequired() && this.m_parameters[n].getValue().length() == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean hasDefaultServerParemeterValues() {
        DiagnosticParameter[] diagnosticParameterArray = this.getParameters();
        int n = diagnosticParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            DiagnosticParameter parameter = diagnosticParameterArray[n2];
            if (!parameter.hasDefaultServerValue()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        XmlToolkit.setSetting((Element)e, (String)XML_ATTRIBUTE_NAME, (String)this.getName());
        DiagnosticParameter[] diagnosticParameterArray = this.getParameters();
        int n = diagnosticParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            DiagnosticParameter parameter = diagnosticParameterArray[n2];
            parameter.exportToXml(e);
            ++n2;
        }
    }

    public String getComponentTag() {
        return TAG_DIAGNOSTIC_COMMAND;
    }

    public void initializeFromXml(Element node) throws Exception {
        List list = XmlToolkit.getChildNodesByTag((Node)node, (String)"DiagnosticParameter");
        if (list != null) {
            DiagnosticParameter[] parameters = this.getParameters();
            block0: for (Element parameterNode : list) {
                String name = XmlToolkit.getSetting((Element)parameterNode, (String)"parameterName", (String)"");
                DiagnosticParameter[] diagnosticParameterArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    DiagnosticParameter parameter = diagnosticParameterArray[n2];
                    if (parameter.getName().equals(name)) {
                        parameter.initializeFromXml(parameterNode);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
    }
}

