/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.diagnostic.form;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.diagnostic.DiagnosticPlugin;
import com.jrockit.mc.console.ui.diagnostic.form.Messages;
import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticCommands;
import com.jrockit.mc.console.ui.diagnostic.model.DiagnosticModel;
import com.jrockit.mc.console.ui.diagnostic.sections.CommandSectionPart;
import com.jrockit.mc.console.ui.diagnostic.sections.LogSectionPart;
import com.jrockit.mc.console.ui.diagnostic.sections.ParameterSectionPart;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.core.ui.MCLayoutFactory;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiagnosticTab
extends ConsoleTab
implements XmlEnabled {
    private static final String PREFERENCE_KEY_DIAGNOSTIC_DATA = "diagnosticData";
    private DiagnosticModel m_model;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.getBody().setLayout(MCLayoutFactory.createFormPageLayout());
        SashForm container = new SashForm(form.getBody(), 512);
        managedForm.getToolkit().adapt((Composite)container);
        container.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        this.m_model = new DiagnosticModel(new DiagnosticCommands(this.getMBeanService(), DiagnosticPlugin.getDefault().getLogger()), DiagnosticPlugin.getDefault().getMCDialogSettings());
        this.createTop(managedForm, (Composite)container, this.m_model);
        this.createBottom(managedForm, (Composite)container, this.m_model);
        form.setMessage(Messages.DiagnosticTab_WARNING_FOR_ADVANCED_USER_TITLE, 2);
        this.initTabFromStore(DiagnosticPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_DIAGNOSTIC_DATA, this);
    }

    private Composite createBottom(IManagedForm managedForm, Composite parent, DiagnosticModel model) {
        LogSectionPart lsp = new LogSectionPart(parent, managedForm.getToolkit(), "console.diagnostic.commands.output", model);
        managedForm.addPart((IFormPart)lsp);
        return lsp.getSection();
    }

    private Composite createTop(IManagedForm managedForm, Composite parent, DiagnosticModel model) {
        SashForm container = new SashForm(parent, 256);
        managedForm.getToolkit().adapt((Composite)container);
        CommandSectionPart csp = new CommandSectionPart((Composite)container, managedForm.getToolkit(), "console.diagnostic.commands.table", ConsolePlugin.getDefault().getMCDialogSettings(), model);
        managedForm.addPart((IFormPart)csp);
        ParameterSectionPart psp = new ParameterSectionPart((Composite)container, managedForm.getToolkit(), "console.diagnostic.commands.parameters", model);
        managedForm.addPart((IFormPart)psp);
        container.setWeights(new int[]{1, 3});
        return container;
    }

    public void doSave(IProgressMonitor monitor) {
        this.exportTabToStore(DiagnosticPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_DIAGNOSTIC_DATA, this);
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        e.setAttribute("uid", this.getConnectionHandle().getDescriptor().getGUID());
        this.m_model.exportToXml(e);
    }

    public String getComponentTag() {
        return "DiagnosticTab";
    }

    public void initializeFromXml(Element node) throws Exception {
        List list = XmlToolkit.getChildNodesByTag((Node)node, (String)"DiagnosticModel");
        if (list != null && list.size() == 1) {
            this.m_model.initializeFromXml((Element)list.get(0));
        }
    }
}

