/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.DisplayUnit;
import com.jrockit.mc.common.unit.FixedDisplayUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnitLookup {
    public static final ContentType MEMORY = UnitLookup.createMemory();
    public static final ContentType UNKNOWN = UnitLookup.createUnknown();
    public static final ContentType TIMESPAN = UnitLookup.createTimespan();
    public static final ContentType COUNT = UnitLookup.createCount();
    public static final ContentType INDEX = UnitLookup.createIndex();
    public static final ContentType TIMESTAMP = UnitLookup.createTimeStamp();
    public static final ContentType PERCENTAGE = UnitLookup.createPercentage();
    public static final ContentType PLAIN_TEXT = UnitLookup.createText();
    public static final ContentType METHOD = UnitLookup.createMethod();
    public static final ContentType CLASS = UnitLookup.createClass();
    public static final ContentType PACKAGE = UnitLookup.createPackage();
    public static final ContentType THREAD = UnitLookup.createThread();
    public static final ContentType ADDRESS = UnitLookup.createAddress();
    public static final ContentType NUMBER = UnitLookup.createNumber();
    private static final List<ContentType> s_types = Collections.unmodifiableList(UnitLookup.createContentTypes());

    public static List<ContentType> getAllContentTypes() {
        return s_types;
    }

    private static ContentType createNumber() {
        ContentType contentType = new ContentType("Number", "number");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "scientificNotation", "Scientific Notation"));
        return contentType;
    }

    private static ContentType createPackage() {
        ContentType contentType = new ContentType("Package", "package");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Default"));
        return contentType;
    }

    private static ContentType createAddress() {
        ContentType contentType = new ContentType("Address", "address");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Default"));
        return contentType;
    }

    private static ContentType createThread() {
        ContentType contentType = new ContentType("Thread", "thread");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Default"));
        return contentType;
    }

    private static ContentType createClass() {
        ContentType contentType = new ContentType("Class", "class");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Default"));
        return contentType;
    }

    private static ContentType createMethod() {
        ContentType contentType = new ContentType("Method", "method");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Default"));
        return contentType;
    }

    private static ContentType createText() {
        ContentType contentType = new ContentType("Text", "text");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Default"));
        return contentType;
    }

    private static List<ContentType> createContentTypes() {
        ArrayList<ContentType> types = new ArrayList<ContentType>();
        types.add(MEMORY);
        types.add(NUMBER);
        types.add(UNKNOWN);
        types.add(TIMESPAN);
        types.add(COUNT);
        types.add(INDEX);
        types.add(TIMESTAMP);
        types.add(PERCENTAGE);
        types.add(PLAIN_TEXT);
        types.add(CLASS);
        types.add(METHOD);
        types.add(THREAD);
        return types;
    }

    public static Map<String, String> createContentTypeMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (ContentType contenType : UnitLookup.getAllContentTypes()) {
            map.put(contenType.getIdentifier(), contenType.getName());
        }
        return map;
    }

    private static ContentType createUnknown() {
        ContentType contentType = new ContentType("Unknown", "unknown");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Default"));
        return contentType;
    }

    private static ContentType createMemory() {
        ContentType contentType = new ContentType("Memory", "memory");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Dynamic"));
        double mega = 1048576.0;
        UnitLookup.addFixed(contentType, "bytes", "Bytes", "bytes", 1.0);
        UnitLookup.addFixed(contentType, "kB", "kB", "kB", 1024.0);
        UnitLookup.addFixed(contentType, "MB", "MB", "MB", mega);
        UnitLookup.addFixed(contentType, "GB", "GB", "GB", 1024.0 * mega);
        UnitLookup.addFixed(contentType, "TB", "TB", "TB", mega * mega);
        return contentType;
    }

    private static void addFixed(ContentType contentType, String identifier, String name, String unitName, double multiplier) {
        FixedDisplayUnit fdu = new FixedDisplayUnit(contentType, identifier, name);
        fdu.setUnitMultiplier(multiplier);
        fdu.setUnitName(unitName);
        contentType.addDisplayUnit(fdu);
    }

    private static ContentType createTimespan() {
        ContentType contentType = new ContentType("Timespan", "timespan");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Dynamic"));
        UnitLookup.addFixed(contentType, "shortNanoseconds", "Nanoseconds", "ns", 1.0);
        UnitLookup.addFixed(contentType, "shortMicroseconds", "Microseconds", "us", 1000.0);
        UnitLookup.addFixed(contentType, "shortMilliseconds", "Milliseconds", "ms", 1000000.0);
        UnitLookup.addFixed(contentType, "shortSeconds", "Seconds", "s", 1.0E9);
        return contentType;
    }

    private static ContentType createTimeStamp() {
        ContentType contentType = new ContentType("Timestamp", "timestamp");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Dynamic"));
        return contentType;
    }

    private static ContentType createPercentage() {
        ContentType contentType = new ContentType("Percentage", "percentage");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "accuracy2digits", "Accuraccy 2 digits)"));
        contentType.addDisplayUnit(new DisplayUnit(contentType, "accuracy0digits", "Accuraccy 0 digits)"));
        contentType.addDisplayUnit(new DisplayUnit(contentType, "accuracy1digit", "Accuraccy 1 digit)"));
        contentType.addDisplayUnit(new DisplayUnit(contentType, "accuracy3digits", "Accuraccy 3 digits)"));
        return contentType;
    }

    private static ContentType createCount() {
        ContentType contentType = new ContentType("Count", "count");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Value"));
        return contentType;
    }

    private static ContentType createIndex() {
        ContentType contentType = new ContentType("Index", "index");
        contentType.addDisplayUnit(new DisplayUnit(contentType, "auto", "Value"));
        return contentType;
    }

    public static ContentType getContentType(String contentTypeIdentifier) {
        for (ContentType type : s_types) {
            if (!contentTypeIdentifier.equals(type.getIdentifier())) continue;
            return type;
        }
        return UNKNOWN;
    }
}

