/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.security.impl;

import com.jrockit.mc.common.security.CodecToolkit;
import com.jrockit.mc.common.security.IEncryptionScheme;
import com.jrockit.mc.common.security.IMasterPasswordChangedListener;
import com.jrockit.mc.common.security.ISecurityManager;
import com.jrockit.mc.common.security.SecurityException;
import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.w3c.dom.Element;

public final class DefaultSecurityManager
implements ISecurityManager,
XmlEnabled {
    public List<IMasterPasswordChangedListener> passwordChangeListeners = Collections.synchronizedList(new ArrayList());
    private static final int ITERATION_COUNT = 4711;
    private static final String RANDOM_GEN_ALGORITHM = "SHA1PRNG";
    private static final String ENCRYPTION_ALGORITHM = "PBEWithSHA1AndDESede";
    private static final int RANDOM_SEED_LEN = 8;
    private static final String XML_ELEMENT_MASTER_PASSWORD = "masterPassword";
    private byte[] passwordHashOnFile;
    private static final IEncryptionScheme ENCRYPTION_SCHEME = new IEncryptionScheme(){

        public String getIdentifier() {
            return "JRMC PBE V1";
        }

        public String getDescription() {
            return "Password based encryption with SHA1 and DESede";
        }

        public String toString() {
            return String.valueOf(this.getIdentifier()) + "/" + this.getDescription();
        }
    };
    private char[] actualPassword;
    private MessageDigest digest;

    public String decrypt(String string) throws SecurityException {
        if (this.actualPassword == null) {
            throw new SecurityException("You must have set a global password to access the passwords.");
        }
        return this.decrypt(CodecToolkit.base64Decode(string));
    }

    public String encrypt(String message) throws SecurityException {
        if (this.actualPassword == null) {
            throw new SecurityException("You are currently not logged in! Encryption services are not available!");
        }
        PBEKeySpec keySpec = new PBEKeySpec(this.actualPassword);
        try {
            byte[] salt = DefaultSecurityManager.getRandom();
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(ENCRYPTION_ALGORITHM);
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 4711);
            Cipher pbeCipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            SecretKey pbeKey = keyFac.generateSecret(keySpec);
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
            byte[] cleartext = message.getBytes("UTF-8");
            byte[] encrypted = pbeCipher.doFinal(cleartext);
            byte[] finalEncrypted = new byte[encrypted.length + salt.length];
            System.arraycopy(salt, 0, finalEncrypted, 0, salt.length);
            System.arraycopy(encrypted, 0, finalEncrypted, salt.length, encrypted.length);
            return CodecToolkit.base64Encode(finalEncrypted);
        }
        catch (Exception e) {
            throw new SecurityException("Could not encrypt!", e);
        }
    }

    private String decrypt(byte[] encrypted) throws SecurityException {
        if (encrypted == null) {
            return null;
        }
        PBEKeySpec keySpec = new PBEKeySpec(this.actualPassword);
        byte[] saltPart = new byte[8];
        System.arraycopy(encrypted, 0, saltPart, 0, saltPart.length);
        byte[] messagePart = new byte[encrypted.length - saltPart.length];
        System.arraycopy(encrypted, saltPart.length, messagePart, 0, messagePart.length);
        try {
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(ENCRYPTION_ALGORITHM);
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(saltPart, 4711);
            Cipher pbeCipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            SecretKey pbeKey = keyFac.generateSecret(keySpec);
            pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
            return new String(pbeCipher.doFinal(messagePart), "UTF-8");
        }
        catch (Exception e) {
            throw new SecurityException("Could not decrypt!", e);
        }
    }

    private static byte[] getRandom() throws Exception {
        SecureRandom random = SecureRandom.getInstance(RANDOM_GEN_ALGORITHM, "SUN");
        return random.generateSeed(8);
    }

    public IEncryptionScheme getEncryptionScheme() {
        return ENCRYPTION_SCHEME;
    }

    public IEncryptionScheme[] getEncryptionSchemes() {
        return new IEncryptionScheme[]{ENCRYPTION_SCHEME};
    }

    public void setEncryptionScheme(IEncryptionScheme encryptionScheme) throws IllegalArgumentException {
        if (encryptionScheme != ENCRYPTION_SCHEME) {
            throw new IllegalArgumentException("The encryption scheme must be one defined by the security manager!");
        }
    }

    public boolean isMasterPasswordSet() {
        return this.actualPassword != null;
    }

    public boolean checkHash(String masterPassword) throws SecurityException {
        return Arrays.equals(this.passwordHashOnFile, this.generatePasswordHash(masterPassword));
    }

    public boolean hasMasterPassword() {
        return this.actualPassword != null;
    }

    public void setMasterPassword(String password) throws SecurityException {
        if (password == null) {
            this.reset();
            return;
        }
        if (password.length() < 5) {
            throw new SecurityException("Master password must be at least 5 characters long!");
        }
        this.actualPassword = password.toCharArray();
        this.passwordHashOnFile = this.generatePasswordHash(password);
        this.fireMasterPasswordChanged(0);
    }

    public boolean hasHash() {
        return this.passwordHashOnFile != null;
    }

    private byte[] generatePasswordHash(String password) throws SecurityException {
        try {
            return this.getMessageDigest().digest(password.getBytes("UTF-8"));
        }
        catch (Exception e) {
            SecurityException se = new SecurityException("Could not set new master password!");
            se.initCause(e);
            throw se;
        }
    }

    private MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        if (this.digest == null) {
            this.digest = MessageDigest.getInstance("sha-1");
        }
        return this.digest;
    }

    private void reset() {
        this.actualPassword = null;
        this.passwordHashOnFile = null;
        this.fireMasterPasswordChanged(1);
    }

    public void exportToXml(Element parent) {
        if (this.passwordHashOnFile != null) {
            Element parentNode = XmlToolkit.createElement(parent, this.getComponentTag());
            XmlToolkit.setSettingAsCData(parentNode, XML_ELEMENT_MASTER_PASSWORD, CodecToolkit.base64Encode(this.passwordHashOnFile));
        }
    }

    public String getComponentTag() {
        return this.getClass().getName();
    }

    public void initializeFromXml(Element parent) throws Exception {
        Element parentNode = XmlToolkit.getOrCreateElement(parent, this.getComponentTag());
        this.actualPassword = null;
        String hash = XmlToolkit.getSettingFromCData(parentNode, XML_ELEMENT_MASTER_PASSWORD, null);
        if (hash != null) {
            this.passwordHashOnFile = CodecToolkit.base64Decode(hash);
        }
    }

    public void addMasterPasswordChangedListener(IMasterPasswordChangedListener listener) {
        this.passwordChangeListeners.add(listener);
    }

    public void removeMasterPasswordChangedListener(IMasterPasswordChangedListener listener) {
        this.passwordChangeListeners.remove(listener);
    }

    private void fireMasterPasswordChanged(int type) {
        IMasterPasswordChangedListener[] listener = this.passwordChangeListeners.toArray(new IMasterPasswordChangedListener[0]);
        int i = 0;
        while (i < listener.length) {
            listener[i].passwordChanged(type);
            ++i;
        }
    }
}

