/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.security;

import com.jrockit.mc.common.security.ISecurityManager;
import com.jrockit.mc.common.security.impl.DefaultSecurityManager;

public final class SecurityManagerFactory {
    private static final String DEFAULT_SECURITY_MANAGER = DefaultSecurityManager.class.getName();
    private static final ISecurityManager instance;

    static {
        ISecurityManager manager = null;
        String className = System.getProperty("com.jrockit.mc.common.security.manager", DEFAULT_SECURITY_MANAGER);
        try {
            Class<?> c = Class.forName(className);
            manager = (ISecurityManager)c.newInstance();
        }
        catch (Exception e) {
            System.out.println("Could not create Security manager for className. Using default! Exception was:");
            e.printStackTrace();
            manager = new DefaultSecurityManager();
        }
        instance = manager;
    }

    public static final ISecurityManager getSecurityManager() {
        return instance;
    }

    private SecurityManagerFactory() {
        throw new AssertionError((Object)"This class is not to be instantiated!");
    }
}

