/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.porting;

public final class JDK14Util {
    private JDK14Util() {
    }

    public static boolean parseBoolean(String s) {
        return s != null && s.equalsIgnoreCase("true");
    }

    public static String getCanonicalName(Class type) {
        if (type.isArray()) {
            String canonicalName = JDK14Util.getCanonicalName(type.getComponentType());
            if (canonicalName != null) {
                return String.valueOf(canonicalName) + "[]";
            }
            return null;
        }
        if (type.isPrimitive()) {
            return null;
        }
        return type.getName();
    }

    public static String getSimpleName(Class type) {
        if (type.isArray()) {
            return String.valueOf(JDK14Util.getSimpleName(type.getComponentType())) + "[]";
        }
        String simpleName = type.getName();
        return simpleName.substring(simpleName.lastIndexOf(46) + 1);
    }

    public static Short valueOf(short s) {
        return new Short(s);
    }

    public static Integer valueOf(int i) {
        return new Integer(i);
    }

    public static Long valueOf(long l) {
        return new Long(l);
    }

    public static String replace(String s, CharSequence target, CharSequence replacement) {
        int i;
        if (s.length() > 0 && target.length() > 0 && replacement.length() >= 0 && (i = s.indexOf(target.toString())) != -1) {
            return String.valueOf(s.substring(0, i)) + replacement + s.substring(i + target.length());
        }
        return s;
    }
}

