/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.persistence;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class SettingList
implements List {
    private Setting m_setting = new Setting("list");
    private List m_list;
    private Type m_type;

    static {
        PersistenceToolkit.registerFetcher(SettingList.class, new ISettingFetcher<SettingList>(){

            @Override
            public Setting getSetting(SettingList sl) {
                return sl.m_setting;
            }
        });
    }

    public SettingList(Type type) {
        this.m_type = type;
    }

    public void add(int index, Object element) {
        this.initialize();
        this.m_setting.addChild(index, PersistenceToolkit.getSetting(element));
        this.m_list.add(index, element);
    }

    private void initialize() {
        if (this.m_list == null) {
            this.m_list = new ArrayList();
            ArrayList<Setting> children = new ArrayList<Setting>(this.m_setting.getChildren());
            this.m_setting.getChildren().clear();
            for (Setting child : children) {
                Object object = PersistenceToolkit.create(this.m_type);
                this.m_list.add(object);
                Setting setting = PersistenceToolkit.getSetting(object);
                Setting.injectSetting(child, setting);
                this.m_setting.addChild(setting);
            }
        }
    }

    public boolean add(Object element) {
        this.initialize();
        this.m_setting.addChild(PersistenceToolkit.getSetting(element));
        this.m_list.add(element);
        return true;
    }

    public boolean addAll(Collection c) {
        this.initialize();
        for (Object o : c) {
            this.add(o);
        }
        return true;
    }

    public Object get(int index) {
        this.initialize();
        if (index < this.size()) {
            return this.m_list.get(index);
        }
        throw new IndexOutOfBoundsException();
    }

    public int size() {
        this.initialize();
        return this.m_list.size();
    }

    public boolean remove(Object o) {
        this.initialize();
        int index = this.m_list.indexOf(o);
        if (index >= 0) {
            this.m_setting.removeChild(index);
            this.m_list.remove(index);
            return true;
        }
        return false;
    }

    public Object remove(int index) {
        this.initialize();
        this.m_setting.removeChild(index);
        return this.m_list.remove(index);
    }

    public boolean removeAll(Collection c) {
        this.initialize();
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    public Object[] toArray() {
        this.initialize();
        Object[] objects = new Object[this.size()];
        int n = 0;
        while (n < objects.length) {
            objects[n] = this.get(n);
            ++n;
        }
        return objects;
    }

    public boolean contains(Object o) {
        this.initialize();
        return this.m_list.contains(o);
    }

    public Object[] toArray(Object[] a) {
        return this.toArray();
    }

    public void clear() {
        this.initialize();
        this.m_list.clear();
        this.m_setting.clear();
    }

    public Object set(int index, Object element) {
        this.initialize();
        Object result = this.m_list.set(index, element);
        this.m_setting.setChild(index, PersistenceToolkit.getSetting(element));
        return result;
    }

    public int indexOf(Object o) {
        this.initialize();
        return this.m_list.indexOf(o);
    }

    public Iterator iterator() {
        return Arrays.asList(this.toArray()).iterator();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        this.initialize();
        return this.m_list.containsAll(c);
    }

    public int lastIndexOf(Object o) {
        this.initialize();
        return this.m_list.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        this.initialize();
        return this.m_list.listIterator();
    }

    public ListIterator listIterator(int index) {
        this.initialize();
        return this.m_list.listIterator(index);
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

