/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.persistence;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PrettyPrinter;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.SettingList;
import com.jrockit.mc.common.persistence.SettingsImportHandler;
import com.jrockit.mc.common.persistence.Type;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistenceToolkit {
    static final String ATTRIBUTE_DEFINITION = "attributes";
    static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static WeakHashMap<Class<? extends Object>, ISettingFetcher<? extends Object>> m_typeFetchers = new WeakHashMap();

    private PersistenceToolkit() {
    }

    static void importFromFile(Setting setting, File importFile) throws IOException {
        FileInputStream fis = new FileInputStream(importFile);
        try {
            PersistenceToolkit.readSetting(setting, fis);
        }
        finally {
            fis.close();
        }
    }

    static void prettyPrint(Writer writer, Setting setting) throws IOException {
        PrettyPrinter p = new PrettyPrinter(writer);
        p.printDeep(setting);
    }

    static void prettyPrintShallow(Writer writer, Setting setting, boolean exportL9nAsText) throws IOException {
        PrettyPrinter p = new PrettyPrinter(writer);
        p.printShallow(setting);
    }

    static void exportToFile(Setting setting, File exportFile) throws IOException {
        PrintWriter fw = new PrintWriter(exportFile, "UTF-8");
        try {
            PersistenceToolkit.writeSetting(fw, setting);
        }
        finally {
            fw.close();
        }
    }

    public static void exportObjectToFile(Object object, File exportFile) throws IOException {
        Setting setting = PersistenceToolkit.getSetting(object);
        PersistenceToolkit.exportToFile(setting, exportFile);
    }

    public static <T> T createObjectFromFile(Class<T> clazz, File file) throws IOException {
        try {
            T object = clazz.newInstance();
            PersistenceToolkit.importIntoObjectFromFile(object, file);
            return object;
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static void importIntoObjectFromFile(Object object, File importFile) throws IOException {
        Setting setting = PersistenceToolkit.getSetting(object);
        setting.clear();
        PersistenceToolkit.importFromFile(setting, importFile);
    }

    private static void writeSetting(Writer writer, Setting setting) throws IOException {
        writer.write(XML_HEADER);
        writer.write("\n");
        new PrettyPrinter(writer).printDeep(setting);
    }

    private static void readSetting(Setting setting, InputStream is) {
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(is, (DefaultHandler)new SettingsImportHandler(setting));
        }
        catch (SAXParseException spe) {
            throw new RuntimeException("Could not parse settings at " + spe.getLineNumber() + " " + spe.getColumnNumber(), spe);
        }
        catch (IOException spe) {
            throw new RuntimeException("Could not parse settings at ", spe);
        }
        catch (SAXException e) {
            throw new RuntimeException("Could not parse settings  ", e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Could not configure sax parser settings  ", e);
        }
    }

    static Setting copy(Setting sourceSetting, Setting parent) {
        Setting copiedSetting = new Setting(sourceSetting.getName());
        Map<String, String> properties = sourceSetting.getProperties();
        for (String key : properties.keySet()) {
            copiedSetting.setChildObject(key, properties.get(key));
        }
        for (Setting child : sourceSetting.getChildren()) {
            copiedSetting.addChild(PersistenceToolkit.copy(child, copiedSetting));
        }
        return copiedSetting;
    }

    static void inject(Setting destination, Setting source) {
        destination.clear();
        Map<String, String> properties = source.getProperties();
        for (String key : properties.keySet()) {
            destination.setChildObject(key, properties.get(key));
        }
        for (Setting child : source.getChildren()) {
            destination.addChild(PersistenceToolkit.copy(child, destination));
        }
    }

    public static <T> void registerFetcher(Class<T> clazz, ISettingFetcher<T> fetcher) {
        m_typeFetchers.put(clazz, fetcher);
    }

    public static <T> Setting getSetting(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        ISettingFetcher<? extends Object> fetcher = m_typeFetchers.get(t.getClass());
        if (fetcher != null) {
            return fetcher.getSetting(t);
        }
        throw new IllegalArgumentException("No settings element for object: " + t + "  could be found");
    }

    static Object create(Type type, Setting source) {
        Object object = PersistenceToolkit.create(type);
        Setting destination = PersistenceToolkit.getSetting(object);
        destination.setName(source.getName());
        return object;
    }

    public static <T> T createWorkingCopy(T t) {
        Object destinationObject = PersistenceToolkit.createInstance(t.getClass());
        Setting destination = PersistenceToolkit.getSetting(destinationObject);
        Setting source = PersistenceToolkit.getSetting(t);
        PersistenceToolkit.inject(destination, source);
        destination.setSource(source);
        return (T)destinationObject;
    }

    public static <T> T createCopy(T t) {
        Object destinationObject = PersistenceToolkit.createInstance(t.getClass());
        Setting destination = PersistenceToolkit.getSetting(destinationObject);
        Setting source = PersistenceToolkit.getSetting(t);
        PersistenceToolkit.inject(destination, source);
        return (T)destinationObject;
    }

    static Setting createSettingWorkingCopy(Setting source) {
        Setting destination = new Setting();
        PersistenceToolkit.inject(destination, source);
        destination.setSource(source);
        return destination;
    }

    static void commit(Setting setting) {
        Setting source = setting.getSource();
        if (source == null) {
            throw new IllegalArgumentException("Not a working copy, or the working copy has alreday been commited");
        }
        PersistenceToolkit.inject(source, setting);
    }

    public static void commit(Object object) {
        PersistenceToolkit.commit(PersistenceToolkit.getSetting(object));
    }

    static Object create(Type type) {
        if (type.getClazz().equals(List.class)) {
            return new SettingList(type.getChild(0));
        }
        return PersistenceToolkit.createInstance(type.getClazz());
    }

    private static Object createInstance(Class<? extends Object> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createObjectFromInputStream(Class<T> clazz, InputStream in) {
        Object object = PersistenceToolkit.createInstance(clazz);
        Setting setting = PersistenceToolkit.getSetting(object);
        setting.clear();
        PersistenceToolkit.readSetting(setting, in);
        return (T)object;
    }

    public static String prettyPrint(Object o, int depth) {
        StringWriter sw = new StringWriter();
        PrettyPrinter pp = new PrettyPrinter(sw);
        try {
            pp.prettyPrint(PersistenceToolkit.getSetting(o), "", depth);
        }
        catch (IOException e) {
            return null;
        }
        return sw.toString();
    }
}

