/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.persistence;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Translations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalizedString {
    private static final Random s_randomNumberGenerator = new Random();
    public static final String LOCALIZATION_PROPERTY_KEY = "l10nKey";
    private static final String LOCALIZED_STRING = "localizedString";
    private Setting m_setting = new Setting("localizedString");
    public static final String LOCALIZATION_PROPERTY_DEFAULT_LOCALE = "default";

    static {
        PersistenceToolkit.registerFetcher(LocalizedString.class, new ISettingFetcher<LocalizedString>(){

            @Override
            public Setting getSetting(LocalizedString sl) {
                return sl.m_setting;
            }
        });
    }

    public List<String> getLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        Map<String, String> props = this.m_setting.getProperties();
        for (String key : props.keySet()) {
            if (key.equals(LOCALIZATION_PROPERTY_KEY)) continue;
            if (key.equals(LOCALIZATION_PROPERTY_DEFAULT_LOCALE)) {
                locales.add("");
                continue;
            }
            locales.add(key);
        }
        return locales;
    }

    public String getPlacementDescription() {
        return this.getPlacementDescription(true, PersistenceToolkit.getSetting(this));
    }

    static String createLocalizationKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(LocalizedString.createRandom16BitHex());
        buffer.append("-");
        buffer.append(LocalizedString.createRandom16BitHex());
        buffer.append("-");
        buffer.append(LocalizedString.createRandom16BitHex());
        buffer.append("-");
        buffer.append(LocalizedString.createRandom16BitHex());
        return buffer.toString();
    }

    private static String createRandom16BitHex() {
        return String.format("%04X", s_randomNumberGenerator.nextInt(65536)).toUpperCase();
    }

    private String getPlacementDescription(boolean first, Setting s) {
        if (s != null) {
            PlacementIdentifier[] placementIdentifierArray = PlacementIdentifier.values();
            int n = placementIdentifierArray.length;
            int n2 = 0;
            while (n2 < n) {
                String defaultName;
                String key;
                PlacementIdentifier pl = placementIdentifierArray[n2];
                Setting localized = s.getChildSetting(pl.getKey());
                if (localized != null && (key = localized.getChildObject(LOCALIZATION_PROPERTY_KEY, String.class)) != null && (defaultName = localized.getChildObject(LOCALIZATION_PROPERTY_DEFAULT_LOCALE, String.class).trim()).length() > 0) {
                    if (first) {
                        defaultName = String.valueOf(defaultName) + "\\" + pl.getName();
                    }
                    return String.valueOf(this.getPlacementDescription(false, s.getParent())) + "\\" + defaultName.trim();
                }
                ++n2;
            }
            return this.getPlacementDescription(first, s.getParent());
        }
        return "";
    }

    public String getPath() {
        return this.getPathForsetting(PersistenceToolkit.getSetting(this));
    }

    private String getPathForsetting(Setting s) {
        if (s == null) {
            return "";
        }
        return String.valueOf(this.getPathForsetting(s.getParent())) + "\\" + s.getName();
    }

    public String getTextInLocale(String locale) {
        if (locale.length() == 0) {
            return this.getTextInLocale(LOCALIZATION_PROPERTY_DEFAULT_LOCALE);
        }
        return this.m_setting.getProperties().get(locale);
    }

    public void setTextForLocale(String locale, String text) {
        if (locale.length() == 0) {
            locale = LOCALIZATION_PROPERTY_DEFAULT_LOCALE;
        }
        this.m_setting.setChildObject(locale, text);
    }

    public static boolean isLocalizedString(Setting s) {
        return s.hasChild(LOCALIZATION_PROPERTY_KEY);
    }

    public LocalizedString() {
        this.setKey(LocalizedString.createLocalizationKey());
    }

    public String getKey() {
        return this.m_setting.getChildObject(LOCALIZATION_PROPERTY_KEY, String.class);
    }

    public String getText() {
        String translation = Translations.getGlobal().getTranslation(this.getKey());
        if (translation == null) {
            translation = this.getSettingsTranslation();
        }
        return translation;
    }

    private String getSettingsTranslation() {
        String[] stringArray = Translations.getVariants();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            String v = stringArray[n2];
            if (v.length() == 0) {
                v = LOCALIZATION_PROPERTY_DEFAULT_LOCALE;
            }
            if ((value = this.m_setting.getProperties().get(v)) != null) {
                return value;
            }
            ++n2;
        }
        return "";
    }

    public void setText(String text) {
        this.m_setting.setChildObject(LOCALIZATION_PROPERTY_DEFAULT_LOCALE, text);
    }

    private void setKey(String key) {
        this.m_setting.setChildObject(LOCALIZATION_PROPERTY_KEY, key);
    }

    public void generateNewKey() {
        this.setKey(LocalizedString.createLocalizationKey());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PlacementIdentifier {
        TITLE("title", "Title"),
        NAME("name", "Name"),
        DESCRIPTION("description", "Description");

        private String m_key;
        private String m_name;

        private PlacementIdentifier(String key, String name) {
            this.m_key = key;
            this.m_name = name;
        }

        String getName() {
            return this.m_name;
        }

        String getKey() {
            return this.m_key;
        }
    }
}

