/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.persistence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalizationProperties {
    private static final String PROPERTIES_FILE_EXTENSION = ".properties";
    private final Map<String, Properties> m_propertiesMap = new HashMap<String, Properties>();
    private String m_activeLocale = Locale.getDefault().toString();
    private boolean m_dirty;

    public LocalizationProperties() {
        this("");
    }

    protected static String[] buildVariants(String root, String extension) {
        String nl = Locale.getDefault().toString();
        ArrayList<String> result = new ArrayList<String>(4);
        while (true) {
            result.add(String.valueOf('_') + nl + extension);
            int lastSeparator = nl.lastIndexOf(95);
            if (lastSeparator == -1) break;
            nl = nl.substring(0, lastSeparator);
        }
        result.add(extension);
        String[] nlSuffixes = result.toArray(new String[result.size()]);
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        int i = 0;
        while (i < variants.length) {
            variants[i] = String.valueOf(root) + nlSuffixes[i];
            ++i;
        }
        return variants;
    }

    public LocalizationProperties(String locale) {
    }

    public void setActiveLocale(String locale) {
        this.m_activeLocale = locale;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public void setDirty(boolean dirty) {
        this.m_dirty = dirty;
    }

    String getProperty(String key) {
        Properties p = this.getProperties(this.getActiveLocale());
        if (p != null) {
            return (String)p.get(key);
        }
        return null;
    }

    private String getActiveLocale() {
        return this.m_activeLocale;
    }

    void setProperty(String key, String value) {
        Properties p = this.getProperties(this.getActiveLocale());
        if (p != null) {
            p = new Properties();
            this.m_propertiesMap.put(this.getActiveLocale(), p);
        }
        p.put(key, value);
        this.m_dirty = true;
    }

    public Properties getProperties(String locale) {
        return this.m_propertiesMap.get(locale);
    }

    public List<String> getLocales() {
        return new ArrayList<String>((Collection)this.m_propertiesMap.keySet());
    }

    void save(File file) throws IOException {
        for (Map.Entry<String, Properties> e : this.m_propertiesMap.entrySet()) {
            this.writeProperties(file, e.getValue());
        }
    }

    void save(File directory, String fileName, List<String> propertyKeys) throws IOException {
        Properties exportable = new Properties();
        for (String locale : this.m_propertiesMap.keySet()) {
            Properties p = this.getProperties(locale);
            for (String propertyKey : propertyKeys) {
                if (!p.containsKey(propertyKey)) continue;
                exportable.put(propertyKey, p.getProperty(propertyKey));
            }
            this.writeProperties(new File(String.valueOf(fileName) + "_" + locale + PROPERTIES_FILE_EXTENSION), p);
        }
    }

    void writeProperties(File file, Properties p) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(file));
        for (Object key : p.keySet()) {
            String value = (String)p.get(key);
            pw.println(key + "=" + value);
        }
        pw.close();
    }

    public void load(File directory, String fileName) throws FileNotFoundException, IOException {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.isPropertiesFile(file)) {
                String locale = this.extractLocale(file);
                Properties currentPropertiesForLocale = this.getProperties(locale);
                Properties importedProperties = this.readProperties(file);
                for (Object objectKey : importedProperties.keySet()) {
                    String key = (String)objectKey;
                    String value = importedProperties.getProperty(key);
                    currentPropertiesForLocale.setProperty(key, value);
                }
            }
            ++n2;
        }
    }

    private boolean isPropertiesFile(File file) {
        return file.getName().startsWith(file.getName()) && file.getName().endsWith(PROPERTIES_FILE_EXTENSION);
    }

    private String extractLocale(File file) {
        String fileName = file.getName();
        int startIndex = fileName.indexOf("_");
        int endIndex = fileName.indexOf(PROPERTIES_FILE_EXTENSION);
        if (startIndex != -1 && endIndex != -1) {
            fileName.substring(startIndex, endIndex);
        }
        return null;
    }

    private Properties readProperties(File f) throws FileNotFoundException, IOException {
        Properties p = new Properties();
        return p;
    }

    public boolean remove(String propertyValue) {
        Properties p = this.getProperties(this.getActiveLocale());
        if (p != null) {
            return p.remove(propertyValue) != null;
        }
        return false;
    }
}

