/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class IOToolkit {
    private static final int[] ZIP_MAGIC = new int[]{80, 75, 3, 4};
    private static final int[] GZ_MAGIC = new int[]{31, 139};

    private IOToolkit() {
        throw new Error("Don't");
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean hasMagic(File file, int[] magic) throws IOException {
        boolean bl;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            bl = IOToolkit.hasMagic(fis, magic);
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(fis);
            throw throwable;
        }
        IOToolkit.closeSilently(fis);
        return bl;
    }

    public static boolean hasMagic(InputStream is, int[] magic) throws IOException {
        int n = 0;
        while (n < magic.length) {
            int b = is.read();
            if (b != magic[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isGZipFile(File file) throws IOException {
        return IOToolkit.hasMagic(file, GZ_MAGIC);
    }

    public static boolean isZipFile(File file) throws IOException {
        return IOToolkit.hasMagic(file, ZIP_MAGIC);
    }
}

