/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.ui.idesupport;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.ide.ui.idesupport.Messages;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

public class IDEToolkit {
    public static final String MISSION_CONTROL_PROJECT_NAME = Messages.IDEToolkit_MISSION_CONTROL_PROJECT_NAME;
    private static final String FILE_COLLISSION_SEPARATOR = "_";
    private static final String FILE_EXTENSION_SEPARATOR = ".";
    private static final int MAX_COLLISSION_TEST_COIUNT = 50;

    public static IProject getMCProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(MISSION_CONTROL_PROJECT_NAME);
    }

    public static void createorOpenMCProject(IWorkbench workbench) {
        try {
            IProject proj = IDEToolkit.getMCProject();
            if (!proj.exists()) {
                proj.create(null);
            }
            proj.open(null);
        }
        catch (Exception e) {
            CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when creating Mission Control project", e);
        }
    }

    public static boolean ensureProject() {
        if (!IDEToolkit.hasOneOpenedProject()) {
            IDEToolkit.createorOpenMCProject(CorePlugin.getDefault().getWorkbench());
            if (!IDEToolkit.hasOneOpenedProject()) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasMCProject() {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(MISSION_CONTROL_PROJECT_NAME);
        return p.exists() && p.isOpen();
    }

    public static boolean hasOneOpenedProject() {
        IProject[] p = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < p.length) {
            if (p[n].isOpen()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String getSafeFileExtensionWithDot(String fileExtension) {
        if (fileExtension == null) {
            return "";
        }
        return FILE_EXTENSION_SEPARATOR + fileExtension;
    }

    public static IPath ensureValidFilePath(IWorkbenchWindow window, IPath filePath) throws IOException {
        IFile file;
        if (filePath.segmentCount() == 2 && MISSION_CONTROL_PROJECT_NAME.equals(filePath.segment(0))) {
            IDEToolkit.createorOpenMCProject(window.getWorkbench());
        }
        if ((file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath)).exists()) {
            String filePathString = filePath.toOSString();
            String fileExtensionString = IDEToolkit.getSafeFileExtensionWithDot(filePath.getFileExtension());
            String fileStringWithoutExtension = filePathString.substring(0, filePathString.length() - fileExtensionString.length());
            int n = 2;
            while (n < 50) {
                Path newPath = new Path(String.valueOf(fileStringWithoutExtension) + FILE_COLLISSION_SEPARATOR + n + fileExtensionString);
                IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)newPath);
                if (!newFile.exists()) {
                    return newPath;
                }
                ++n;
            }
        }
        return filePath;
    }
}

