/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.ui.idesupport;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.idesupport.BasicIDESupport;
import com.jrockit.mc.core.idesupport.IIDESupport;
import com.jrockit.mc.core.idesupport.TrayManager;
import com.jrockit.mc.ide.ui.idesupport.FileCreationWizard;
import com.jrockit.mc.ide.ui.idesupport.IDEToolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class EclipseIDESupport
implements IIDESupport {
    private BasicIDESupport m_basicSupport = new BasicIDESupport();

    public File getFileFromEditorInput(IEditorInput input) {
        if (input instanceof IURIEditorInput) {
            IURIEditorInput uriIEditorInput = (IURIEditorInput)input;
            return new File(uriIEditorInput.getURI());
        }
        if (input instanceof IPathEditorInput) {
            IPathEditorInput pathEditorInput = (IPathEditorInput)input;
            IPath path = null;
            try {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(pathEditorInput.getPath());
                path = file.getLocation();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (path == null) {
                path = pathEditorInput.getPath();
            }
            return path.toFile();
        }
        return this.m_basicSupport.getFileFromEditorInput(input);
    }

    public IPath browseForSaveAsFile(IWorkbenchWindow window, String title, String suggestedName, IPath containerFullPath, String fileExtension, ImageDescriptor descriptor, String description) {
        if (IDEToolkit.ensureProject()) {
            WizardNewFileCreationPage fcp = new WizardNewFileCreationPage(title, (IStructuredSelection)new StructuredSelection());
            fcp.setFileExtension(fileExtension);
            if (containerFullPath != null && containerFullPath.toFile().exists()) {
                fcp.setContainerFullPath(containerFullPath);
            }
            fcp.setFileName(suggestedName);
            fcp.setFileExtension(fileExtension);
            fcp.setTitle(title);
            fcp.setDescription(description);
            FileCreationWizard wizard = new FileCreationWizard(fcp);
            wizard.setDefaultPageImageDescriptor(descriptor);
            wizard.setDialogSettings(CorePlugin.getDefault().getMCDialogSettings());
            wizard.addPage((IWizardPage)fcp);
            WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
            dialog.setTitle(title);
            if (dialog.open() == 0) {
                IPath containerPath = wizard.getContainerFullPath();
                if (containerPath != null) {
                    containerPath = containerPath.append(wizard.getFileName());
                    String pathFileExtension = containerPath.getFileExtension();
                    if (fileExtension != null && pathFileExtension != null && fileExtension.equals(pathFileExtension)) {
                        containerPath.addFileExtension(fileExtension);
                    }
                }
                this.m_basicSupport.saveLastPath(containerPath);
                return containerPath;
            }
        }
        return null;
    }

    public void checkIfWorkspaceIsInUse() throws IOException {
    }

    public IFolder getValidFolder(IFile file) {
        IFolder folder;
        IContainer c = file.getParent();
        if (c instanceof IFolder && (folder = (IFolder)c).exists()) {
            return folder;
        }
        return null;
    }

    private IProject getvalidProject(IFile file) {
        IProject project = file.getProject();
        if (project != null && project.exists() && project.isOpen()) {
            return project;
        }
        return null;
    }

    public boolean hasSuffix(IPath path, String suffix) {
        return path != null && suffix != null && suffix.equals(path.getFileExtension());
    }

    public IPath getValidDefaultFile(String prefix, String suffix) {
        IPath lastPath = this.m_basicSupport.getLastPath(suffix);
        if (lastPath != null && this.hasSuffix(lastPath, suffix)) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(lastPath);
            IFolder folder = this.getValidFolder(file);
            IProject project = this.getvalidProject(file);
            if (project != null) {
                IPath path;
                if (folder != null) {
                    int n = 1;
                    while (n < 50) {
                        IFile newFile = folder.getFile(EclipseIDESupport.getFileName(n, prefix, suffix));
                        if (!newFile.exists()) {
                            return newFile.getFullPath();
                        }
                        ++n;
                    }
                }
                if ((path = this.createInProject(prefix, suffix, file.getProject())) != null) {
                    return path;
                }
            }
        }
        if (IDEToolkit.hasMCProject()) {
            return this.createInProject(prefix, suffix, IDEToolkit.getMCProject());
        }
        return EclipseIDESupport.createDefaultMCFilePath(prefix, suffix);
    }

    static IPath createDefaultMCFilePath(String prefix, String suffix) {
        File file = new File(IDEToolkit.MISSION_CONTROL_PROJECT_NAME, EclipseIDESupport.getFileName(1, prefix, suffix));
        return new Path(file.getPath());
    }

    static String getFileName(int n, String prefix, String suffix) {
        if (n == 1) {
            return String.valueOf(prefix) + "." + suffix;
        }
        return String.valueOf(prefix) + n + "." + suffix;
    }

    private IPath createInProject(String prefix, String suffix, IProject proj) {
        int n = 1;
        while (n < 50) {
            IFile newFile = proj.getFile(EclipseIDESupport.getFileName(n, prefix, suffix));
            if (!newFile.exists()) {
                return newFile.getFullPath();
            }
            ++n;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized IPath writeToFile(IWorkbenchWindow window, IPath filePath, InputStream stream, IProgressMonitor monitor) throws IOException {
        IPath validPath = IDEToolkit.ensureValidFilePath(window, filePath);
        if (validPath == null) {
            return null;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(validPath);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        try {
            block6: {
                IPath iPath;
                try {
                    file.create(stream, true, (IProgressMonitor)subMonitor);
                    if (subMonitor.isCanceled()) break block6;
                    subMonitor = new SubProgressMonitor(monitor, 1);
                    file.refreshLocal(1, (IProgressMonitor)subMonitor);
                    if (subMonitor.isCanceled()) break block6;
                    iPath = validPath;
                    Object var8_9 = null;
                }
                catch (CoreException coreException) {
                    monitor.setCanceled(true);
                    throw new IOException("Could not save file " + filePath + " in workspace");
                }
                monitor.done();
                return iPath;
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return validPath;
    }

    public boolean supportsLoggerConfiguration() {
        return false;
    }

    public TrayManager getTrayManager() {
        return null;
    }

    public void setTrayManager(TrayManager trayManager) {
        throw new UnsupportedOperationException("Can't set TrayManager for EclipseIDESupport");
    }
}

