/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.providers.AbstractSampler;

public class SubsamplingBuffer
extends AbstractSampler {
    protected int m_sampleCount = -1;
    private double m_lastX;

    public SubsamplingBuffer(int size) {
        super(size);
        this.samples = new SamplePoint[size];
        int i = 0;
        while (i < size) {
            this.samples[i] = new SamplePoint();
            this.samples[i].x = i;
            this.samples[i].sampled = false;
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.samples.length) {
            this.samples[i].y = 0.0;
            this.samples[i].yOut = 0.0;
            this.samples[i].count = 0L;
            this.samples[i].sampled = false;
            this.samples[i].min = Double.POSITIVE_INFINITY;
            this.samples[i].max = Double.NEGATIVE_INFINITY;
            this.samples[i].x = i;
            ++i;
        }
        this.m_minY = Double.NaN;
        this.m_maxY = Double.NaN;
        this.m_sampleCount = -1;
    }

    public void addDataPoint(double normalizedX, double currentY) {
        if (normalizedX < 0.0 || normalizedX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedX);
        }
        assert (this.isLargerThanLast(normalizedX));
        this.addSamplePoint((double)(this.samples.length - 1) * normalizedX, currentY);
    }

    private boolean isLargerThanLast(double normalizedX) {
        boolean assertion = normalizedX >= this.m_lastX;
        this.m_lastX = normalizedX;
        return assertion;
    }

    protected void addSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.samples.length) {
            SamplePoint point = this.samples[currentIndex];
            if (!point.sampled) {
                point.y = currentY;
                point.sampled = true;
            }
            point.min = Math.min(point.min, currentY);
            point.max = Math.max(point.max, currentY);
            point.yOut = currentY;
            ++point.count;
            this.m_maxY = Math.max(this.m_maxY, point.max);
            this.m_minY = Math.min(this.m_minY, point.min);
            ++this.m_count;
        }
    }

    protected void calcStatistics() {
        int n = 0;
        while (n < this.samples.length) {
            if (this.samples[n].hasSample()) {
                if (this.m_logarithmic && this.samples[n].y != 0.0) {
                    this.samples[n].y = Math.log(this.samples[n].y + 3.0);
                }
                if (Double.isNaN(this.m_maxY)) {
                    this.m_maxY = this.samples[n].y;
                    this.m_minY = this.samples[n].y;
                }
                this.m_maxY = Math.max(this.samples[n].y, this.m_maxY);
                this.m_minY = Math.min(this.samples[n].y, this.m_minY);
                ++this.m_sampleCount;
            }
            ++n;
        }
    }
}

