/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.providers.AbstractSampler;

public final class StackingBuffer
extends AbstractSampler {
    public StackingBuffer(int size) {
        super(size);
    }

    public void addNonNormalizedDataPoint(double currentX, double currentY) {
        this.addSamplePoint(currentX, currentY);
    }

    protected void addSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.samples.length) {
            ++this.samples[currentIndex].count;
            this.samples[currentIndex].y += currentY;
            this.samples[currentIndex].sampled = true;
            ++this.m_count;
        }
    }

    protected void calcStatistics() {
        int n = 0;
        while (n < this.samples.length) {
            if (this.samples[n].hasSample()) {
                if (Double.isNaN(this.m_maxY)) {
                    this.m_maxY = this.samples[n].y;
                    this.m_minY = this.samples[n].y;
                }
                this.m_maxY = Math.max(this.samples[n].y, this.m_maxY);
                this.m_minY = Math.min(this.samples[n].y, this.m_minY);
                this.m_sampleCount = (int)((long)this.m_sampleCount + this.samples[n].count);
            }
            ++n;
        }
    }
}

