/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.hirt.greychart.XAxis;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataChangeListener;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.IXYData;
import se.hirt.greychart.impl.LongWorldToDeviceConverter;
import se.hirt.greychart.impl.OptimizingProvider;
import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.impl.WorldToDeviceConverter;
import se.hirt.greychart.providers.IntegratingSampleCountingBuffer;
import se.hirt.greychart.providers.SampleCountingBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleCountingProvider
implements OptimizingProvider {
    private final DataSeries<IXYData> m_dataSeries;
    private final XAxis m_xAxis;
    private SampleCountingBuffer m_sampleBuffer = new SampleCountingBuffer(0);
    private List m_samplesList = new LinkedList();
    private boolean m_sampleListInvalid = true;
    private long m_startX;
    private long m_endX;
    private int m_requestedResolution = 0;
    private long m_requestedStartX = Long.MIN_VALUE;
    private long m_requestedEndX = Long.MAX_VALUE;
    private int m_lastWidth;
    private volatile boolean dataChangeOccured = false;
    private boolean m_integrate = false;
    private boolean m_abort = false;

    public SampleCountingProvider(DataSeries<IXYData> s, XAxis xAxis) {
        this.m_dataSeries = s;
        this.m_xAxis = xAxis;
        s.addChangeListener(new DataChangeListener(){

            public void onDataChange(DataChangeEvent event) {
                SampleCountingProvider.this.dataChangeOccured = true;
            }
        });
    }

    @Override
    public void dispose() {
        this.m_sampleBuffer = null;
    }

    @Override
    public boolean update() {
        if (this.isScheduleResample()) {
            this.scheduleResample(this.m_requestedResolution);
            this.dataChangeOccured = false;
            return true;
        }
        return false;
    }

    private boolean isScheduleResample() {
        return this.hasRangeChanged() || this.hasDataChanged() || this.isSampleBufferInvalid();
    }

    private boolean hasRangeChanged() {
        return this.m_startX != this.m_requestedStartX || this.m_endX != this.m_requestedEndX;
    }

    @Override
    public void setDataChanged(boolean changed) {
        this.dataChangeOccured = changed;
    }

    @Override
    public boolean hasDataChanged() {
        return this.dataChangeOccured;
    }

    private boolean isSampleBufferInvalid() {
        return this.m_sampleBuffer == null || this.m_sampleBuffer.getSize() != this.m_requestedResolution;
    }

    private boolean isSampleListInvalid() {
        return this.m_sampleListInvalid || this.isSampleBufferInvalid();
    }

    @Override
    public void abort() {
        this.m_abort = true;
    }

    @Override
    public void setResolution(int resolution) {
        this.m_requestedResolution = resolution;
    }

    private void scheduleResample(int resolution) {
        this.m_sampleBuffer = this.createSampleBuffer(resolution);
        this.m_samplesList.clear();
        this.m_startX = this.m_requestedStartX;
        this.m_endX = this.m_requestedEndX;
    }

    @Override
    public Iterator<SamplePoint> getSamples(int width) {
        if (this.isSampleListInvalid()) {
            this.m_samplesList = this.createSampleList(width);
        }
        return this.m_samplesList.iterator();
    }

    @Override
    public Polygon getSamplesPolygon(LongWorldToDeviceConverter xWorldToDevice, WorldToDeviceConverter yWorldToDevice) {
        int deviceWidth = xWorldToDevice.getDeviceWidth();
        int[] xs = new int[deviceWidth * 3 + 3];
        int[] ys = new int[deviceWidth * 3 + 3];
        int index = 0;
        if (yWorldToDevice.canCalculateDeviceCoordinate()) {
            Iterator<SamplePoint> it = this.getSamples(deviceWidth);
            int previousY = 0;
            int zeroY = yWorldToDevice.getDeviceCoordinate(0.0);
            while (it.hasNext() && index < deviceWidth * 3) {
                SamplePoint sp = it.next();
                int currentY = yWorldToDevice.getDeviceCoordinate(sp.y);
                int currentX = sp.x;
                if (currentY != previousY && index > 0) {
                    xs[index] = xs[index - 1];
                    ys[index] = zeroY;
                    xs[++index] = currentX;
                    ys[index] = zeroY;
                    ++index;
                }
                xs[index] = currentX;
                ys[index] = currentY;
                ++index;
                previousY = currentY;
            }
        }
        return new Polygon(xs, ys, index);
    }

    private List createSampleList(int width) {
        SamplePoint[] points = this.m_sampleBuffer.getSamples();
        ArrayList<SamplePoint> list = new ArrayList<SamplePoint>(this.m_sampleBuffer.getSize());
        int n = 0;
        while (n < points.length) {
            if (points[n].hasSample()) {
                list.add(points[n]);
            }
            ++n;
        }
        return list;
    }

    private SampleCountingBuffer createSampleBuffer(int width) {
        SampleCountingBuffer sampleBuffer = null;
        if (this.m_lastWidth == width) {
            sampleBuffer = this.m_sampleBuffer;
            sampleBuffer.reset();
        } else {
            sampleBuffer = this.isIntegrate() ? new IntegratingSampleCountingBuffer(width) : new SampleCountingBuffer(width);
            this.m_lastWidth = width;
        }
        long worldWidth = this.m_xAxis.getMax().longValue() - this.m_xAxis.getMin().longValue();
        long leftEdge = this.m_xAxis.getMin().longValue();
        Iterator<IXYData> it = this.m_dataSeries.createIterator(this.m_requestedStartX, this.m_requestedEndX);
        if (!it.hasNext()) {
            return sampleBuffer;
        }
        IXYData data = this.findFirstPoint(sampleBuffer, it, worldWidth, leftEdge);
        long x = this.getXAsLong(data);
        if (x >= leftEdge && x <= leftEdge + worldWidth) {
            this.addXYDataPoint(sampleBuffer, worldWidth, leftEdge, data);
        }
        while (it.hasNext() && !this.m_abort) {
            data = it.next();
            x = this.getXAsLong(data);
            if (x < leftEdge && this.isIntegrate()) {
                this.addLeftEdgeCrossingValue(sampleBuffer, worldWidth, leftEdge, data);
                continue;
            }
            if (x >= leftEdge + worldWidth) continue;
            this.addXYDataPoint(sampleBuffer, worldWidth, leftEdge, data);
        }
        if (this.isIntegrate()) {
            ((IntegratingSampleCountingBuffer)sampleBuffer).fixSamples();
        }
        this.m_abort = false;
        return sampleBuffer;
    }

    private void addLeftEdgeCrossingValue(SampleCountingBuffer sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        long y;
        long x = this.getXAsLong(data);
        if (x + (y = this.getYAsLong(data)) >= leftEdge) {
            this.addIntegratedValue((IntegratingSampleCountingBuffer)sampleBuffer, worldWidth, leftEdge, leftEdge, y, x + y - leftEdge);
        }
    }

    private long getXAsLong(IXYData data) {
        return ((Number)data.getX()).longValue();
    }

    private long getYAsLong(IXYData data) {
        return ((Number)data.getY()).longValue();
    }

    /*
     * Unable to fully structure code
     */
    private IXYData findFirstPoint(SampleCountingBuffer sampleBuffer, Iterator<IXYData> it, long worldWidth, long leftEdge) {
        firstDataPoint = null;
        if (!it.hasNext() || (x = this.getXAsLong(firstDataPoint = it.next())) < leftEdge) ** GOTO lbl11
        return firstDataPoint;
lbl-1000:
        // 1 sources

        {
            data = it.next();
            x = this.getXAsLong(data);
            if (this.isIntegrate()) {
                this.addLeftEdgeCrossingValue(sampleBuffer, worldWidth, leftEdge, firstDataPoint);
            }
            if (x >= leftEdge) {
                return data;
            }
            firstDataPoint = data;
lbl11:
            // 2 sources

            ** while (it.hasNext())
        }
lbl12:
        // 1 sources

        return firstDataPoint;
    }

    private void addXYDataPoint(SampleCountingBuffer sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        if (this.isIntegrate()) {
            this.addIntegratedXYDataPoint((IntegratingSampleCountingBuffer)sampleBuffer, worldWidth, leftEdge, data);
        } else {
            this.addNormalXYDataPoint(sampleBuffer, worldWidth, leftEdge, data);
        }
    }

    private void addNormalXYDataPoint(SampleCountingBuffer sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        double n = this.getNormalizedX(this.getXAsLong(data), worldWidth, leftEdge);
        double y = ((Number)data.getY()).doubleValue();
        sampleBuffer.addDataPoint(n, y);
    }

    private void addIntegratedValue(IntegratingSampleCountingBuffer sampleBuffer, long worldWidth, long leftEdge, long x, long y, long duration) {
        double n = this.getNormalizedX(x, worldWidth, leftEdge);
        double n2 = this.getNormalizedX(Math.min(leftEdge + worldWidth, x + duration), worldWidth, leftEdge);
        sampleBuffer.addDataPoint(n, n2, 1.0);
    }

    private void addIntegratedXYDataPoint(IntegratingSampleCountingBuffer sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        this.addIntegratedValue(sampleBuffer, worldWidth, leftEdge, this.getXAsLong(data), this.getYAsLong(data), this.getYAsLong(data));
    }

    private double getNormalizedX(long x, long worldWidth, long leftEdge) {
        return (double)(x - leftEdge) / (double)worldWidth;
    }

    @Override
    public DataSeries getDataSeries() {
        return this.m_dataSeries;
    }

    @Override
    public OptimizingProvider[] getChildren() {
        return new OptimizingProvider[0];
    }

    @Override
    public synchronized long getMaxX() {
        return this.m_endX;
    }

    @Override
    public synchronized long getMinX() {
        return this.m_startX;
    }

    @Override
    public double getMaxY() {
        return this.m_sampleBuffer.getMaxY();
    }

    @Override
    public double getMinY() {
        return this.m_sampleBuffer.getMinY();
    }

    @Override
    public synchronized void setRange(long start, long end) {
        this.m_requestedStartX = start;
        this.m_requestedEndX = end;
        this.update();
    }

    @Override
    public long getValueCount() {
        return this.m_sampleBuffer.getDataPointCount();
    }

    @Override
    public void setIntegrate(boolean integrate) {
        this.m_integrate = integrate;
    }

    private boolean isIntegrate() {
        return this.m_integrate;
    }
}

