/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.impl.LongWorldToDeviceConverter;
import se.hirt.greychart.impl.OptimizingProvider;
import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.impl.WorldToDeviceConverter;
import se.hirt.greychart.providers.SampleCountingProvider;
import se.hirt.greychart.providers.StackingBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntermediateStackingProvider
implements OptimizingProvider {
    private final OptimizingProvider[] providers;
    private final OptimizingProvider topProvider;
    private long m_requestedStartX = Long.MIN_VALUE;
    private long m_requestedEndX = Long.MAX_VALUE;
    private int m_requestedResolution = 0;
    private StackingBuffer m_sampleBuffer;
    private List m_samplesList = new LinkedList();
    private int m_lastSubSampleWidth = -1;
    private volatile boolean dataChangeOccured = false;

    public IntermediateStackingProvider(OptimizingProvider topProvider, OptimizingProvider[] providers) {
        int nProviders = 0;
        OptimizingProvider[] optimizingProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider prov = optimizingProviderArray[n2];
            if (prov != null) {
                ++nProviders;
            }
            ++n2;
        }
        OptimizingProvider[] myProviders = new OptimizingProvider[nProviders];
        int index = 0;
        OptimizingProvider[] optimizingProviderArray2 = providers;
        int n3 = providers.length;
        int n4 = 0;
        while (n4 < n3) {
            OptimizingProvider prov = optimizingProviderArray2[n4];
            if (prov != null) {
                myProviders[index] = prov;
                ++index;
            }
            ++n4;
        }
        this.providers = myProviders;
        this.topProvider = topProvider;
        this.m_sampleBuffer = new StackingBuffer(0);
    }

    @Override
    public void dispose() {
        this.topProvider.dispose();
    }

    @Override
    public void setDataChanged(boolean changed) {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setDataChanged(changed);
            ++n2;
        }
        this.dataChangeOccured = true;
    }

    @Override
    public boolean hasDataChanged() {
        if (this.dataChangeOccured) {
            return true;
        }
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            if (provider.hasDataChanged()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void abort() {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.abort();
            ++n2;
        }
    }

    private boolean hasRangeChanged() {
        return this.getMinX() != this.m_requestedStartX || this.getMaxX() != this.m_requestedEndX;
    }

    private StackingBuffer createStackSampledBuffer(int width) {
        this.dataChangeOccured = false;
        this.m_lastSubSampleWidth = width;
        StackingBuffer stackSampleBuffer = null;
        stackSampleBuffer = new StackingBuffer(width);
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            Iterator<SamplePoint> it = provider.getSamples(width);
            while (it.hasNext()) {
                SamplePoint point = it.next();
                if (!point.hasSample()) continue;
                stackSampleBuffer.addNonNormalizedDataPoint(point.x, point.y);
            }
            ++n2;
        }
        return stackSampleBuffer;
    }

    private List createSampleList(int width) {
        SamplePoint[] points = this.m_sampleBuffer.getSamples();
        ArrayList<SamplePoint> list = new ArrayList<SamplePoint>(this.m_sampleBuffer.getSize());
        int n = 0;
        while (n < points.length) {
            if (points[n].hasSample()) {
                list.add(points[n]);
            }
            ++n;
        }
        return list;
    }

    @Override
    public Iterator<SamplePoint> getSamples(int width) {
        if (width != this.m_lastSubSampleWidth || this.hasDataChanged() || this.hasRangeChanged() || this.m_samplesList.isEmpty()) {
            this.m_sampleBuffer = this.createStackSampledBuffer(width);
        }
        this.m_samplesList = this.createSampleList(width);
        return this.m_samplesList.iterator();
    }

    @Override
    public Polygon getSamplesPolygon(LongWorldToDeviceConverter xWorldToDevice, WorldToDeviceConverter yWorldToDevice) {
        int deviceWidth = xWorldToDevice.getDeviceWidth();
        int[] xs = new int[deviceWidth * 2 + 3];
        int[] ys = new int[deviceWidth * 2 + 3];
        int index = 0;
        if (yWorldToDevice.canCalculateDeviceCoordinate()) {
            Iterator<SamplePoint> it = this.getSamples(deviceWidth);
            int previousY = 0;
            boolean sampleCounting = this.topProvider instanceof SampleCountingProvider;
            int onePixelY = yWorldToDevice.getDeviceCoordinate(0.0) - 2;
            while (it.hasNext() && index < deviceWidth * 2) {
                SamplePoint sp = it.next();
                int currentY = yWorldToDevice.getDeviceCoordinate(sp.y);
                if (sampleCounting && sp.y > 0.0 && currentY > onePixelY) {
                    currentY = onePixelY;
                }
                int currentX = sp.x;
                if (currentY != previousY && index > 0) {
                    xs[index] = currentX;
                    ys[index] = previousY;
                    ++index;
                }
                xs[index] = currentX;
                ys[index] = currentY;
                ++index;
                previousY = currentY;
            }
        }
        return new Polygon(xs, ys, index);
    }

    @Override
    public void setResolution(int resolution) {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setResolution(resolution);
            ++n2;
        }
        this.m_requestedResolution = resolution;
    }

    @Override
    public boolean update() {
        boolean update = false;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            if (provider.update()) {
                update = true;
            }
            ++n2;
        }
        return update;
    }

    @Override
    public OptimizingProvider[] getChildren() {
        return this.providers;
    }

    @Override
    public DataSeries getDataSeries() {
        return this.topProvider.getDataSeries();
    }

    @Override
    public long getMaxX() {
        return this.topProvider.getMaxX();
    }

    @Override
    public double getMaxY() {
        if (this.hasDataChanged() || this.hasRangeChanged() || this.m_sampleBuffer.getSize() == 0) {
            this.m_sampleBuffer = this.createStackSampledBuffer(this.m_requestedResolution);
        }
        return this.m_sampleBuffer.getMaxY();
    }

    @Override
    public double getMinY() {
        if (this.hasDataChanged() || this.hasRangeChanged() || this.m_sampleBuffer.getSize() == 0) {
            this.m_sampleBuffer = this.createStackSampledBuffer(this.m_requestedResolution);
        }
        return this.m_sampleBuffer.getMinY();
    }

    @Override
    public long getMinX() {
        return this.topProvider.getMinX();
    }

    @Override
    public void setRange(long start, long end) {
        this.m_requestedStartX = start;
        this.m_requestedEndX = end;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setRange(start, end);
            ++n2;
        }
    }

    @Override
    public long getValueCount() {
        return this.topProvider.getValueCount();
    }

    @Override
    public void setIntegrate(boolean integrate) {
    }
}

