/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.providers.SubsamplingBuffer;

public class IntegratingSubsamplingBuffer
extends SubsamplingBuffer {
    public IntegratingSubsamplingBuffer(int size) {
        super(size);
        this.samples = new SamplePoint[size];
        int i = 0;
        while (i < size) {
            this.samples[i] = new SamplePoint();
            this.samples[i].x = i;
            this.samples[i].yOut = 0.0;
            this.samples[i].count = 0L;
            this.samples[i].sampled = false;
            this.samples[i].min = 0.0;
            this.samples[i].max = 0.0;
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.samples.length) {
            this.samples[i].y = 0.0;
            this.samples[i].yOut = 0.0;
            this.samples[i].count = 0L;
            this.samples[i].sampled = false;
            this.samples[i].min = 0.0;
            this.samples[i].max = 0.0;
            this.samples[i].x = i;
            ++i;
        }
        this.m_minY = Double.NaN;
        this.m_maxY = Double.NaN;
        this.m_sampleCount = -1;
    }

    public void addDataPoint(double normalizedStartX, double normalizedEndX, double value) {
        if (normalizedStartX < 0.0 || normalizedStartX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedStartX);
        }
        if (normalizedEndX < 0.0 || normalizedEndX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedEndX);
        }
        this.addStartSamplePoint((double)this.samples.length * normalizedStartX, value);
        this.addEndSamplePoint(Math.max((double)this.samples.length * normalizedEndX, (double)this.samples.length * normalizedStartX + 1.0), -value);
    }

    protected void addStartSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.samples.length) {
            ++this.samples[currentIndex].count;
            this.samples[currentIndex].y += currentY;
            this.samples[currentIndex].max = Math.max(currentY, this.samples[currentIndex].max);
            this.samples[currentIndex].sampled = true;
            ++this.m_count;
        }
    }

    protected void addEndSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.samples.length) {
            ++this.samples[currentIndex].count;
            this.samples[currentIndex].y += currentY;
            this.samples[currentIndex].sampled = true;
            ++this.m_count;
        }
    }

    protected void addSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.samples.length) {
            ++this.samples[currentIndex].count;
            this.samples[currentIndex].y += currentY;
            this.samples[currentIndex].sampled = true;
            ++this.m_count;
        }
    }

    public void fixSamples() {
        double currentSum = 0.0;
        double currentY = 0.0;
        int n = 0;
        while (n < this.samples.length) {
            if (this.samples[n].sampled) {
                double maxY = this.samples[n].max;
                double incY = this.samples[n].y;
                double oldY = currentY;
                double maxNewY = Math.max(currentY, maxY);
                currentY = Math.min(maxNewY, currentSum += incY);
                this.samples[n].y = oldY;
                this.samples[n].yOut = currentY;
                this.samples[n].count = 2L;
            }
            ++n;
        }
        if (!this.samples[this.samples.length - 1].sampled && currentY > 0.0) {
            this.samples[this.samples.length - 1].y = currentY;
            this.samples[this.samples.length - 1].yOut = currentY;
            this.samples[this.samples.length - 1].count = 1L;
            this.samples[this.samples.length - 1].sampled = true;
        }
    }

    protected void calcStatistics() {
        int n = 0;
        while (n < this.samples.length) {
            if (this.samples[n].hasSample()) {
                if (this.m_logarithmic && this.samples[n].y != 0.0) {
                    this.samples[n].y = Math.log(this.samples[n].y + 3.0);
                }
                if (Double.isNaN(this.m_maxY)) {
                    this.m_maxY = this.samples[n].y;
                    this.m_minY = this.samples[n].y;
                }
                this.m_maxY = Math.max(this.samples[n].y, this.m_maxY);
                this.m_minY = Math.min(this.samples[n].y, this.m_minY);
                this.m_sampleCount = (int)((long)this.m_sampleCount + this.samples[n].count);
            }
            ++n;
        }
    }
}

